/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.rv.drag;

import android.content.Context;
import androidx.annotation.RequiresPermission;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.lodz.android.pandora.widget.rv.drag.DragHelperCallback;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001c\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 J*\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bJ\u0006\u0010\"\u001a\u00020\rJ\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ5\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002'\u0010%\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0011J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010'\u001a\u00020\u0007J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010'\u001a\u00020\u0007J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010*\u001a\u00020\u0007J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010,\u001a\u00020\u0007J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010.\u001a\u00020\u0007J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010'\u001a\u00020\u0007H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u0010\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/lodz/android/pandora/widget/rv/drag/RecyclerViewDragHelper;", "T", "", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isPdrLongPressDragEnabled", "", "isPdrSwipeEnabled", "isPdrVibrateEnabled", "mPdrCallback", "Lcom/lodz/android/pandora/widget/rv/drag/DragHelperCallback;", "mPdrItemTouchHelper", "Landroidx/recyclerview/widget/ItemTouchHelper;", "mPdrList", "", "mPdrListener", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "list", "", "mPdrUseDrag", "mPdrUseLeftToRightSwipe", "mPdrUseRightToLeftSwipe", "build", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "callback", "Landroidx/recyclerview/widget/ItemTouchHelper$Callback;", "adapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "getItemTouchHelper", "setList", "setListener", "listener", "setLongPressDragEnabled", "enabled", "setSwipeEnabled", "setUseDrag", "useDrag", "setUseLeftToRightSwipe", "leftToRightSwipe", "setUseRightToLeftSwipe", "rightToLeftSwipe", "setVibrateEnabled", "pandora_release"})
public final class RecyclerViewDragHelper<T> {
    @NotNull
    private final Context mContext;
    private boolean mPdrUseDrag;
    private boolean mPdrUseRightToLeftSwipe;
    private boolean mPdrUseLeftToRightSwipe;
    private boolean isPdrLongPressDragEnabled;
    private boolean isPdrSwipeEnabled;
    private boolean isPdrVibrateEnabled;
    @Nullable
    private Function1<? super List<? extends T>, Unit> mPdrListener;
    @Nullable
    private List<T> mPdrList;
    @Nullable
    private DragHelperCallback<T> mPdrCallback;
    @Nullable
    private ItemTouchHelper mPdrItemTouchHelper;

    public RecyclerViewDragHelper(@NotNull Context mContext) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        this.mPdrUseDrag = true;
        this.mPdrUseRightToLeftSwipe = true;
        this.mPdrUseLeftToRightSwipe = true;
        this.isPdrLongPressDragEnabled = true;
        this.isPdrSwipeEnabled = true;
    }

    @NotNull
    public final RecyclerViewDragHelper<T> setUseDrag(boolean useDrag) {
        this.mPdrUseDrag = useDrag;
        DragHelperCallback<T> dragHelperCallback = this.mPdrCallback;
        if (dragHelperCallback != null) {
            dragHelperCallback.setUseDrag(useDrag);
        }
        return this;
    }

    @NotNull
    public final RecyclerViewDragHelper<T> setUseRightToLeftSwipe(boolean rightToLeftSwipe) {
        this.mPdrUseRightToLeftSwipe = rightToLeftSwipe;
        DragHelperCallback<T> dragHelperCallback = this.mPdrCallback;
        if (dragHelperCallback != null) {
            dragHelperCallback.setUseRightToLeftSwipe(rightToLeftSwipe);
        }
        return this;
    }

    @NotNull
    public final RecyclerViewDragHelper<T> setUseLeftToRightSwipe(boolean leftToRightSwipe) {
        this.mPdrUseLeftToRightSwipe = leftToRightSwipe;
        DragHelperCallback<T> dragHelperCallback = this.mPdrCallback;
        if (dragHelperCallback != null) {
            dragHelperCallback.setUseLeftToRightSwipe(leftToRightSwipe);
        }
        return this;
    }

    @NotNull
    public final RecyclerViewDragHelper<T> setLongPressDragEnabled(boolean enabled) {
        this.isPdrLongPressDragEnabled = enabled;
        DragHelperCallback<T> dragHelperCallback = this.mPdrCallback;
        if (dragHelperCallback != null) {
            dragHelperCallback.setLongPressDrag(enabled);
        }
        return this;
    }

    @NotNull
    public final RecyclerViewDragHelper<T> setSwipeEnabled(boolean enabled) {
        this.isPdrSwipeEnabled = enabled;
        DragHelperCallback<T> dragHelperCallback = this.mPdrCallback;
        if (dragHelperCallback != null) {
            dragHelperCallback.setSwipe(enabled);
        }
        return this;
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    @NotNull
    public final RecyclerViewDragHelper<T> setVibrateEnabled(boolean enabled) {
        this.isPdrVibrateEnabled = enabled;
        DragHelperCallback<T> dragHelperCallback = this.mPdrCallback;
        if (dragHelperCallback != null) {
            dragHelperCallback.setVibrate(enabled);
        }
        return this;
    }

    @NotNull
    public final RecyclerViewDragHelper<T> setList(@NotNull List<T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.mPdrList = list;
        DragHelperCallback<T> dragHelperCallback = this.mPdrCallback;
        if (dragHelperCallback != null) {
            dragHelperCallback.setList(list);
        }
        return this;
    }

    @NotNull
    public final RecyclerViewDragHelper<T> setListener(@NotNull Function1<? super List<? extends T>, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.mPdrListener = listener;
        DragHelperCallback<T> dragHelperCallback = this.mPdrCallback;
        if (dragHelperCallback != null) {
            dragHelperCallback.setListener(listener);
        }
        return this;
    }

    public final void build(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        this.build(recyclerView, adapter, new DragHelperCallback());
    }

    public final void build(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.Adapter<RecyclerView.ViewHolder> adapter, @NotNull DragHelperCallback<T> callback) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        callback.setContext(this.mContext);
        callback.setUseDrag(this.mPdrUseDrag);
        callback.setUseRightToLeftSwipe(this.mPdrUseRightToLeftSwipe);
        callback.setUseLeftToRightSwipe(this.mPdrUseLeftToRightSwipe);
        callback.setLongPressDrag(this.isPdrLongPressDragEnabled);
        callback.setSwipe(this.isPdrSwipeEnabled);
        callback.setVibrate(this.isPdrVibrateEnabled);
        callback.setListener(this.mPdrListener);
        callback.setList(this.mPdrList);
        callback.setAdapter(adapter);
        this.mPdrCallback = callback;
        this.build(recyclerView, callback);
    }

    public final void build(@NotNull RecyclerView recyclerView, @NotNull ItemTouchHelper.Callback callback) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        ItemTouchHelper itemTouchHelper = this.mPdrItemTouchHelper = new ItemTouchHelper(callback);
        if (itemTouchHelper != null) {
            itemTouchHelper.attachToRecyclerView(recyclerView);
        }
    }

    @NotNull
    public final ItemTouchHelper getItemTouchHelper() {
        if (this.mPdrItemTouchHelper == null) {
            throw new RuntimeException("please call build() first");
        }
        ItemTouchHelper itemTouchHelper = this.mPdrItemTouchHelper;
        Intrinsics.checkNotNull((Object)itemTouchHelper);
        return itemTouchHelper;
    }
}

