/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.webview;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.lodz.android.corekt.anko.AnkoContextCompatKt;
import com.lodz.android.corekt.anko.AnkoDimensionsKt;
import com.lodz.android.corekt.log.PrintLog;
import com.lodz.android.pandora.R;
import com.lodz.android.pandora.widget.webview.OnPgStatusChangeListener;
import com.lodz.android.pandora.widget.webview.PgWebChromeClient;
import com.lodz.android.pandora.widget.webview.PgWebViewClient;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\b\u0016\u0018\u0000 22\u00020\u0001:\u00012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\b\u0010 \u001a\u00020\u001eH\u0002J\b\u0010!\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020\u001eH\u0002J\u0006\u0010&\u001a\u00020\u000eJ\u0006\u0010'\u001a\u00020\u000eJ\u000e\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020\u001eH\u0014J\u0006\u0010,\u001a\u00020\u001eJ\u0006\u0010-\u001a\u00020\u001eJ\u000e\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020*J\u0010\u00100\u001a\u00020\u001e2\b\u00101\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/lodz/android/pandora/widget/webview/PgWebView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "isPdrLoadSuccess", "", "mPdrListener", "Lcom/lodz/android/pandora/widget/webview/OnPgStatusChangeListener;", "mPdrProgressBar", "Landroid/widget/ProgressBar;", "mPdrWebView", "Landroid/webkit/WebView;", "createProgressBar", "lp", "Landroid/widget/FrameLayout$LayoutParams;", "createWebChromeClient", "Lcom/lodz/android/pandora/widget/webview/PgWebChromeClient;", "createWebView", "createWebViewClient", "Lcom/lodz/android/pandora/widget/webview/PgWebViewClient;", "goBack", "", "goForward", "init", "initViews", "initWebSettings", "settings", "Landroid/webkit/WebSettings;", "initWebView", "isCanForward", "isCanGoBack", "loadUrl", "url", "", "onInit", "release", "reload", "setLogTag", "tag", "setOnPgStatusChangeListener", "listener", "Companion", "pandora_release"})
public class PgWebView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private WebView mPdrWebView;
    private ProgressBar mPdrProgressBar;
    @Nullable
    private OnPgStatusChangeListener mPdrListener;
    private boolean isPdrLoadSuccess;
    @NotNull
    private static String TAG = "PgWebViewTag";

    public PgWebView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.isPdrLoadSuccess = true;
        this.init();
    }

    public PgWebView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.isPdrLoadSuccess = true;
        this.init();
    }

    public PgWebView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.isPdrLoadSuccess = true;
        this.init();
    }

    @TargetApi(value=21)
    public PgWebView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.isPdrLoadSuccess = true;
        this.init();
    }

    private final void init() {
        this.initViews();
        this.initWebView();
        this.onInit();
    }

    private final void initViews() {
        this.mPdrWebView = this.createWebView(new FrameLayout.LayoutParams(-1, -1));
        WebView webView = this.mPdrWebView;
        this.addView((View)this.mPdrWebView, webView == null ? null : webView.getLayoutParams());
        this.mPdrProgressBar = this.createProgressBar(new FrameLayout.LayoutParams(-1, AnkoDimensionsKt.dp2px((View)((View)this), (int)3)));
        webView = this.mPdrProgressBar;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrProgressBar");
            throw null;
        }
        View view = (View)webView;
        webView = this.mPdrProgressBar;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrProgressBar");
            throw null;
        }
        this.addView(view, webView.getLayoutParams());
    }

    @NotNull
    protected WebView createWebView(@NotNull FrameLayout.LayoutParams lp) {
        Intrinsics.checkNotNullParameter((Object)lp, (String)"lp");
        WebView wv = new WebView(this.getContext());
        wv.setLayoutParams((ViewGroup.LayoutParams)lp);
        return wv;
    }

    @NotNull
    protected ProgressBar createProgressBar(@NotNull FrameLayout.LayoutParams lp) {
        Intrinsics.checkNotNullParameter((Object)lp, (String)"lp");
        ProgressBar pg = new ProgressBar(this.getContext(), null, 16842872);
        pg.setMax(100);
        pg.setProgress(0);
        pg.setProgressDrawable(AnkoContextCompatKt.getDrawableCompat((View)((View)this), (int)R.drawable.pandora_bg_ffffff_progress_aaaaaa));
        pg.setVisibility(8);
        pg.setLayoutParams((ViewGroup.LayoutParams)lp);
        return pg;
    }

    private final void initWebView() {
        WebView wv = this.mPdrWebView;
        if (wv != null) {
            PgWebViewClient wvc = this.createWebViewClient();
            wvc.setListener$pandora_release(new OnPgStatusChangeListener(this){
                final /* synthetic */ PgWebView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onProgressChanged(@Nullable WebView webView, int progress) {
                }

                public void onPageStarted(@Nullable WebView webView, @Nullable String url, @Nullable Bitmap favicon) {
                    Object object = PgWebView.access$getMPdrProgressBar$p(this.this$0);
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrProgressBar");
                        throw null;
                    }
                    object.setVisibility(0);
                    PrintLog.wS((String)PgWebView.Companion.getTAG$pandora_release(), (String)"onPageStarted");
                    object = PgWebView.access$getMPdrListener$p(this.this$0);
                    if (object != null) {
                        object.onPageStarted(webView, url, favicon);
                    }
                }

                public void onReceivedError(@Nullable WebView webView, @Nullable WebResourceRequest request, @Nullable WebResourceError error) {
                    Object object = PgWebView.access$getMPdrProgressBar$p(this.this$0);
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrProgressBar");
                        throw null;
                    }
                    object.setVisibility(8);
                    PgWebView.access$setPdrLoadSuccess$p(this.this$0, false);
                    PrintLog.eS((String)PgWebView.Companion.getTAG$pandora_release(), (String)String.valueOf(error));
                    object = PgWebView.access$getMPdrListener$p(this.this$0);
                    if (object != null) {
                        object.onReceivedError(webView, request, error);
                    }
                }

                public void onPageFinished(@Nullable WebView webView, @Nullable String url) {
                    PrintLog.iS((String)PgWebView.Companion.getTAG$pandora_release(), (String)"onPageFinished");
                    if (!PgWebView.access$isPdrLoadSuccess$p(this.this$0)) {
                        PgWebView.access$setPdrLoadSuccess$p(this.this$0, true);
                        return;
                    }
                    Object object = PgWebView.access$getMPdrProgressBar$p(this.this$0);
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrProgressBar");
                        throw null;
                    }
                    object.setVisibility(8);
                    object = PgWebView.access$getMPdrListener$p(this.this$0);
                    if (object != null) {
                        object.onPageFinished(webView, url);
                    }
                }
            });
            wv.setWebViewClient((WebViewClient)wvc);
            PgWebChromeClient wcc = this.createWebChromeClient();
            wcc.setListener$pandora_release(new OnPgStatusChangeListener(this){
                final /* synthetic */ PgWebView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onProgressChanged(@Nullable WebView webView, int progress) {
                    PrintLog.dS((String)PgWebView.Companion.getTAG$pandora_release(), (String)Intrinsics.stringPlus((String)"Progress : ", (Object)progress));
                    Object object = PgWebView.access$getMPdrProgressBar$p(this.this$0);
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrProgressBar");
                        throw null;
                    }
                    object.setProgress(progress);
                    object = PgWebView.access$getMPdrProgressBar$p(this.this$0);
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrProgressBar");
                        throw null;
                    }
                    object.setVisibility(progress == 100 ? 8 : 0);
                    object = PgWebView.access$getMPdrListener$p(this.this$0);
                    if (object != null) {
                        object.onProgressChanged(webView, progress);
                    }
                }

                public void onPageStarted(@Nullable WebView webView, @Nullable String url, @Nullable Bitmap favicon) {
                }

                public void onReceivedError(@Nullable WebView webView, @Nullable WebResourceRequest request, @Nullable WebResourceError error) {
                }

                public void onPageFinished(@Nullable WebView webView, @Nullable String url) {
                }
            });
            wv.setWebChromeClient((WebChromeClient)wcc);
            WebSettings webSettings = wv.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)webSettings, (String)"wv.settings");
            this.initWebSettings(webSettings);
        }
    }

    @NotNull
    protected PgWebViewClient createWebViewClient() {
        return new PgWebViewClient();
    }

    @NotNull
    protected PgWebChromeClient createWebChromeClient() {
        return new PgWebChromeClient();
    }

    protected void initWebSettings(@NotNull WebSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        settings.setDefaultTextEncodingName(StandardCharsets.UTF_8.toString());
        settings.setLoadsImagesAutomatically(true);
        settings.setUseWideViewPort(true);
        settings.setLoadWithOverviewMode(true);
        settings.setCacheMode(2);
    }

    protected void onInit() {
    }

    public final void setLogTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        CharSequence charSequence = tag;
        boolean bl = false;
        if (charSequence.length() > 0) {
            TAG = tag;
        }
    }

    public final void loadUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        WebView webView = this.mPdrWebView;
        if (webView != null) {
            webView.loadUrl(url);
        }
    }

    public final boolean isCanGoBack() {
        boolean bl;
        WebView webView = this.mPdrWebView;
        return webView == null ? false : (bl = webView.canGoBack());
    }

    public final void goBack() {
        WebView webView = this.mPdrWebView;
        if (webView != null) {
            webView.goBack();
        }
    }

    public final boolean isCanForward() {
        boolean bl;
        WebView webView = this.mPdrWebView;
        return webView == null ? false : (bl = webView.canGoForward());
    }

    public final void goForward() {
        WebView webView = this.mPdrWebView;
        if (webView != null) {
            webView.goForward();
        }
    }

    public final void reload() {
        WebView webView = this.mPdrWebView;
        if (webView != null) {
            webView.reload();
        }
    }

    public final void release() {
        WebView webView = this.mPdrWebView;
        if (webView != null) {
            webView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
        }
        webView = this.mPdrWebView;
        if (webView != null) {
            webView.clearHistory();
        }
        webView = this.mPdrWebView;
        if (webView != null) {
            webView.clearCache(true);
        }
        webView = this.mPdrWebView;
        if (webView != null) {
            webView.destroy();
        }
        this.mPdrWebView = null;
    }

    public final void setOnPgStatusChangeListener(@Nullable OnPgStatusChangeListener listener) {
        this.mPdrListener = listener;
    }

    public void _$_clearFindViewByIdCache() {
    }

    public static final /* synthetic */ ProgressBar access$getMPdrProgressBar$p(PgWebView $this) {
        return $this.mPdrProgressBar;
    }

    public static final /* synthetic */ OnPgStatusChangeListener access$getMPdrListener$p(PgWebView $this) {
        return $this.mPdrListener;
    }

    public static final /* synthetic */ void access$setPdrLoadSuccess$p(PgWebView $this, boolean bl) {
        $this.isPdrLoadSuccess = bl;
    }

    public static final /* synthetic */ boolean access$isPdrLoadSuccess$p(PgWebView $this) {
        return $this.isPdrLoadSuccess;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/lodz/android/pandora/widget/webview/PgWebView$Companion;", "", "()V", "TAG", "", "getTAG$pandora_release", "()Ljava/lang/String;", "setTAG$pandora_release", "(Ljava/lang/String;)V", "pandora_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG$pandora_release() {
            return TAG;
        }

        public final void setTAG$pandora_release(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            TAG = string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

