/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;

public class QueryInterruptedException
extends RuntimeException {
    public static final String QUERY_INTERRUPTED = "Query interrupted";
    public static final String QUERY_TIMEOUT = "Query timeout";
    public static final String QUERY_CANCELLED = "Query cancelled";
    public static final String UNKNOWN_EXCEPTION = "Unknown exception";
    private static final Set<String> listKnownException = ImmutableSet.of((Object)"Query cancelled", (Object)"Query interrupted", (Object)"Query timeout", (Object)"Unknown exception");
    @JsonProperty
    private final String causeMessage;
    @JsonProperty
    private final String host;

    @JsonCreator
    public QueryInterruptedException(@JsonProperty(value="error") String message, @JsonProperty(value="causeMessage") String causeMessage, @JsonProperty(value="host") String host) {
        super(message);
        this.causeMessage = causeMessage;
        this.host = host;
    }

    public QueryInterruptedException(Throwable cause) {
        this(cause, null);
    }

    public QueryInterruptedException(Throwable e, String host) {
        super(e);
        this.host = host;
        this.causeMessage = e.getMessage();
    }

    @Override
    @JsonProperty(value="error")
    public String getMessage() {
        if (this.getCause() == null) {
            return super.getMessage();
        }
        if (this.getCause() instanceof QueryInterruptedException) {
            return this.getCause().getMessage();
        }
        if (this.getCause() instanceof InterruptedException) {
            return QUERY_INTERRUPTED;
        }
        if (this.getCause() instanceof CancellationException) {
            return QUERY_CANCELLED;
        }
        if (this.getCause() instanceof TimeoutException) {
            return QUERY_TIMEOUT;
        }
        return UNKNOWN_EXCEPTION;
    }

    @JsonProperty(value="causeMessage")
    public String getCauseMessage() {
        return this.causeMessage;
    }

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    public boolean isNotKnown() {
        return !listKnownException.contains(this.getMessage());
    }
}

