/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.collect.Lists;
import com.metamx.common.Pair;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class AggregatorUtil {
    public static final byte STRING_SEPARATOR = -1;

    public static List<PostAggregator> pruneDependentPostAgg(List<PostAggregator> postAggregatorList, String postAggName) {
        LinkedList rv = Lists.newLinkedList();
        HashSet<String> deps = new HashSet<String>();
        deps.add(postAggName);
        for (PostAggregator agg : Lists.reverse(postAggregatorList)) {
            if (!deps.contains(agg.getName())) continue;
            rv.addFirst(agg);
            deps.remove(agg.getName());
            deps.addAll(agg.getDependentFields());
        }
        return rv;
    }

    public static Pair<List<AggregatorFactory>, List<PostAggregator>> condensedAggregators(List<AggregatorFactory> aggList, List<PostAggregator> postAggList, String metric) {
        List<PostAggregator> condensedPostAggs = AggregatorUtil.pruneDependentPostAgg(postAggList, metric);
        HashSet<String> dependencySet = new HashSet<String>();
        dependencySet.add(metric);
        for (PostAggregator postAggregator : condensedPostAggs) {
            dependencySet.addAll(postAggregator.getDependentFields());
        }
        ArrayList condensedAggs = Lists.newArrayList();
        for (AggregatorFactory aggregatorSpec : aggList) {
            if (!dependencySet.contains(aggregatorSpec.getName())) continue;
            condensedAggs.add(aggregatorSpec);
        }
        return new Pair((Object)condensedAggs, condensedPostAggs);
    }
}

