/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import javax.annotation.Nullable;

public abstract class FunctionalExtraction
extends DimExtractionFn {
    private final boolean retainMissingValue;
    private final String replaceMissingValueWith;
    private final Function<String, String> extractionFunction;
    private final ExtractionFn.ExtractionType extractionType;

    public FunctionalExtraction(final Function<String, String> extractionFunction, boolean retainMissingValue, String replaceMissingValueWith, boolean injective) {
        this.retainMissingValue = retainMissingValue;
        this.replaceMissingValueWith = Strings.emptyToNull((String)replaceMissingValueWith);
        Preconditions.checkArgument((!this.retainMissingValue || Strings.isNullOrEmpty((String)this.replaceMissingValueWith) ? 1 : 0) != 0, (Object)"Cannot specify a [replaceMissingValueWith] and set [retainMissingValue] to true");
        this.extractionFunction = this.retainMissingValue ? new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String dimValue) {
                String retval = (String)extractionFunction.apply((Object)dimValue);
                return Strings.isNullOrEmpty((String)retval) ? Strings.emptyToNull((String)dimValue) : retval;
            }
        } : new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String dimValue) {
                String retval = (String)extractionFunction.apply((Object)dimValue);
                return Strings.isNullOrEmpty((String)retval) ? FunctionalExtraction.this.replaceMissingValueWith : retval;
            }
        };
        this.extractionType = injective ? ExtractionFn.ExtractionType.ONE_TO_ONE : ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public boolean isRetainMissingValue() {
        return this.retainMissingValue;
    }

    public String getReplaceMissingValueWith() {
        return this.replaceMissingValueWith;
    }

    public boolean isInjective() {
        return ExtractionFn.ExtractionType.ONE_TO_ONE.equals((Object)this.getExtractionType());
    }

    @Override
    public String apply(String value) {
        return (String)this.extractionFunction.apply((Object)value);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return this.extractionType;
    }
}

