/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.metamx.common.StringUtils;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import java.nio.ByteBuffer;

public class StringFormatExtractionFn
extends DimExtractionFn {
    private final String format;
    private final NullHandling nullHandling;

    @JsonCreator
    public StringFormatExtractionFn(@JsonProperty(value="format") String format, @JsonProperty(value="nullHandling") NullHandling nullHandling) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)format) ? 1 : 0) != 0, (Object)"format string should not be empty");
        this.format = format;
        this.nullHandling = nullHandling == null ? NullHandling.NULLSTRING : nullHandling;
    }

    public StringFormatExtractionFn(String format) {
        this(format, NullHandling.NULLSTRING);
    }

    @JsonProperty
    public String getFormat() {
        return this.format;
    }

    @JsonProperty
    public NullHandling getNullHandling() {
        return this.nullHandling;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] bytes = StringUtils.toUtf8((String)this.format);
        return ByteBuffer.allocate(2 + bytes.length).put((byte)10).put((byte)this.nullHandling.ordinal()).put(bytes).array();
    }

    @Override
    public String apply(String value) {
        if (value == null) {
            if (this.nullHandling == NullHandling.RETURNNULL) {
                return null;
            }
            if (this.nullHandling == NullHandling.EMPTYSTRING) {
                value = "";
            }
        }
        return Strings.emptyToNull((String)String.format(this.format, value));
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringFormatExtractionFn that = (StringFormatExtractionFn)o;
        if (this.nullHandling != that.nullHandling) {
            return false;
        }
        return this.format.equals(that.format);
    }

    public int hashCode() {
        int result = this.format.hashCode();
        result = 31 * result + this.nullHandling.ordinal();
        return result;
    }

    public String toString() {
        return "StringFormatExtractionFn{format='" + this.format + '\'' + ", nullHandling=" + (Object)((Object)this.nullHandling) + '}';
    }

    public static enum NullHandling {
        NULLSTRING,
        EMPTYSTRING,
        RETURNNULL;


        @JsonCreator
        public static NullHandling forValue(String value) {
            return value == null ? NULLSTRING : NullHandling.valueOf(value.toUpperCase());
        }

        @JsonValue
        public String toValue() {
            return this.name().toLowerCase();
        }
    }
}

