/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.ibm.icu.text.SimpleDateFormat;
import com.metamx.common.StringUtils;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Date;

public class TimeDimExtractionFn
extends DimExtractionFn {
    private final String timeFormat;
    private final SimpleDateFormat timeFormatter;
    private final String resultFormat;
    private final SimpleDateFormat resultFormatter;

    @JsonCreator
    public TimeDimExtractionFn(@JsonProperty(value="timeFormat") String timeFormat, @JsonProperty(value="resultFormat") String resultFormat) {
        Preconditions.checkNotNull((Object)timeFormat, (Object)"timeFormat must not be null");
        Preconditions.checkNotNull((Object)resultFormat, (Object)"resultFormat must not be null");
        this.timeFormat = timeFormat;
        this.timeFormatter = new SimpleDateFormat(timeFormat);
        this.timeFormatter.setLenient(true);
        this.resultFormat = resultFormat;
        this.resultFormatter = new SimpleDateFormat(resultFormat);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] timeFormatBytes = StringUtils.toUtf8((String)this.timeFormat);
        return ByteBuffer.allocate(1 + timeFormatBytes.length).put((byte)0).put(timeFormatBytes).array();
    }

    @Override
    public String apply(String dimValue) {
        Date date;
        try {
            date = this.timeFormatter.parse(dimValue);
        }
        catch (ParseException e) {
            return dimValue;
        }
        return this.resultFormatter.format(date);
    }

    @JsonProperty(value="timeFormat")
    public String getTimeFormat() {
        return this.timeFormat;
    }

    @JsonProperty(value="resultFormat")
    public String getResultFormat() {
        return this.resultFormat;
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public String toString() {
        return "TimeDimExtractionFn{timeFormat='" + this.timeFormat + '\'' + ", resultFormat='" + this.resultFormat + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeDimExtractionFn that = (TimeDimExtractionFn)o;
        if (!this.resultFormat.equals(that.resultFormat)) {
            return false;
        }
        return this.timeFormat.equals(that.timeFormat);
    }

    public int hashCode() {
        int result = this.timeFormat.hashCode();
        result = 31 * result + this.resultFormat.hashCode();
        return result;
    }
}

