/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.StringUtils;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.DimFilterCacheHelper;
import io.druid.query.filter.Filter;
import io.druid.segment.filter.BoundFilter;
import java.nio.ByteBuffer;

public class BoundDimFilter
implements DimFilter {
    private final String dimension;
    private final String upper;
    private final String lower;
    private final boolean lowerStrict;
    private final boolean upperStrict;
    private final boolean alphaNumeric;
    private final ExtractionFn extractionFn;

    @JsonCreator
    public BoundDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="lower") String lower, @JsonProperty(value="upper") String upper, @JsonProperty(value="lowerStrict") Boolean lowerStrict, @JsonProperty(value="upperStrict") Boolean upperStrict, @JsonProperty(value="alphaNumeric") Boolean alphaNumeric, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension can not be null");
        Preconditions.checkState((lower != null || upper != null ? 1 : 0) != 0, (Object)"lower and upper can not be null at the same time");
        this.upper = upper;
        this.lower = lower;
        this.lowerStrict = lowerStrict == null ? false : lowerStrict;
        this.upperStrict = upperStrict == null ? false : upperStrict;
        this.alphaNumeric = alphaNumeric == null ? false : alphaNumeric;
        this.extractionFn = extractionFn;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getUpper() {
        return this.upper;
    }

    @JsonProperty
    public String getLower() {
        return this.lower;
    }

    @JsonProperty
    public boolean isLowerStrict() {
        return this.lowerStrict;
    }

    @JsonProperty
    public boolean isUpperStrict() {
        return this.upperStrict;
    }

    @JsonProperty
    public boolean isAlphaNumeric() {
        return this.alphaNumeric;
    }

    public boolean hasLowerBound() {
        return this.lower != null;
    }

    public boolean hasUpperBound() {
        return this.upper != null;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.getDimension());
        byte[] lowerBytes = this.getLower() == null ? new byte[]{} : StringUtils.toUtf8((String)this.getLower());
        byte[] upperBytes = this.getUpper() == null ? new byte[]{} : StringUtils.toUtf8((String)this.getUpper());
        byte boundType = 1;
        if (this.getLower() == null) {
            boundType = 2;
        } else if (this.getUpper() == null) {
            boundType = 3;
        }
        byte lowerStrictByte = !this.isLowerStrict() ? (byte)0 : 1;
        byte upperStrictByte = !this.isUpperStrict() ? (byte)0 : 1;
        byte AlphaNumericByte = !this.isAlphaNumeric() ? (byte)0 : 1;
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        ByteBuffer boundCacheBuffer = ByteBuffer.allocate(9 + dimensionBytes.length + upperBytes.length + lowerBytes.length + extractionFnBytes.length);
        boundCacheBuffer.put(DimFilterCacheHelper.BOUND_CACHE_ID).put(boundType).put(upperStrictByte).put(lowerStrictByte).put(AlphaNumericByte).put((byte)-1).put(dimensionBytes).put((byte)-1).put(upperBytes).put((byte)-1).put(lowerBytes).put((byte)-1).put(extractionFnBytes);
        return boundCacheBuffer.array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new BoundFilter(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundDimFilter that = (BoundDimFilter)o;
        if (this.isLowerStrict() != that.isLowerStrict()) {
            return false;
        }
        if (this.isUpperStrict() != that.isUpperStrict()) {
            return false;
        }
        if (this.isAlphaNumeric() != that.isAlphaNumeric()) {
            return false;
        }
        if (!this.getDimension().equals(that.getDimension())) {
            return false;
        }
        if (this.getUpper() != null ? !this.getUpper().equals(that.getUpper()) : that.getUpper() != null) {
            return false;
        }
        if (this.getLower() != null ? !this.getLower().equals(that.getLower()) : that.getLower() != null) {
            return false;
        }
        return this.getExtractionFn() != null ? this.getExtractionFn().equals(that.getExtractionFn()) : that.getExtractionFn() == null;
    }

    public int hashCode() {
        int result = this.getDimension().hashCode();
        result = 31 * result + (this.getUpper() != null ? this.getUpper().hashCode() : 0);
        result = 31 * result + (this.getLower() != null ? this.getLower().hashCode() : 0);
        result = 31 * result + (this.isLowerStrict() ? 1 : 0);
        result = 31 * result + (this.isUpperStrict() ? 1 : 0);
        result = 31 * result + (this.isAlphaNumeric() ? 1 : 0);
        result = 31 * result + (this.getExtractionFn() != null ? this.getExtractionFn().hashCode() : 0);
        return result;
    }
}

