/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.guava.Accumulator;
import io.druid.collections.StupidPool;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.MapBasedRow;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.incremental.OffheapIncrementalIndex;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GroupByQueryHelper {
    private static final String CTX_KEY_MAX_RESULTS = "maxResults";
    public static final String CTX_KEY_SORT_RESULTS = "sortResults";

    public static <T> Pair<IncrementalIndex, Accumulator<IncrementalIndex, T>> createIndexAccumulatorPair(GroupByQuery query, GroupByQueryConfig config, StupidPool<ByteBuffer> bufferPool) {
        QueryGranularity gran = query.getGranularity();
        long timeStart = query.getIntervals().get(0).getStartMillis();
        long granTimeStart = gran.iterable(timeStart, timeStart + 1L).iterator().next();
        List aggs = Lists.transform(query.getAggregatorSpecs(), (Function)new Function<AggregatorFactory, AggregatorFactory>(){

            public AggregatorFactory apply(AggregatorFactory input) {
                return input.getCombiningFactory();
            }
        });
        final List dimensions = Lists.transform(query.getDimensions(), (Function)new Function<DimensionSpec, String>(){

            public String apply(DimensionSpec input) {
                return input.getOutputName();
            }
        });
        boolean sortResults = query.getContextValue(CTX_KEY_SORT_RESULTS, true);
        IncrementalIndex index = query.getContextValue("useOffheap", false) != false ? new OffheapIncrementalIndex(granTimeStart, gran, aggs.toArray(new AggregatorFactory[aggs.size()]), false, true, sortResults, Math.min(query.getContextValue(CTX_KEY_MAX_RESULTS, config.getMaxResults()), config.getMaxResults()), bufferPool) : new OnheapIncrementalIndex(granTimeStart, gran, aggs.toArray(new AggregatorFactory[aggs.size()]), false, true, sortResults, Math.min(query.getContextValue(CTX_KEY_MAX_RESULTS, config.getMaxResults()), config.getMaxResults()));
        Accumulator accumulator = new Accumulator<IncrementalIndex, T>(){

            public IncrementalIndex accumulate(IncrementalIndex accumulated, T in) {
                if (in instanceof MapBasedRow) {
                    try {
                        MapBasedRow row = (MapBasedRow)in;
                        accumulated.add((InputRow)new MapBasedInputRow(row.getTimestamp(), dimensions, row.getEvent()));
                    }
                    catch (IndexSizeExceededException e) {
                        throw new ISE(e.getMessage(), new Object[0]);
                    }
                } else {
                    throw new ISE("Unable to accumulate something of type [%s]", new Object[]{in.getClass()});
                }
                return accumulated;
            }
        };
        return new Pair((Object)index, (Object)accumulator);
    }

    public static <T> Pair<Queue, Accumulator<Queue, T>> createBySegmentAccumulatorPair() {
        ConcurrentLinkedQueue init = new ConcurrentLinkedQueue();
        Accumulator accumulator = new Accumulator<Queue, T>(){

            public Queue accumulate(Queue accumulated, T in) {
                if (in == null) {
                    throw new ISE("Cannot have null result", new Object[0]);
                }
                accumulated.offer(in);
                return accumulated;
            }
        };
        return new Pair(init, (Object)accumulator);
    }
}

