/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.ResourceClosingSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.collections.StupidPool;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.granularity.QueryGranularity;
import io.druid.guice.annotations.Global;
import io.druid.query.BaseQuery;
import io.druid.query.CacheStrategy;
import io.druid.query.DataSource;
import io.druid.query.DruidMetrics;
import io.druid.query.IntervalChunkingQueryRunnerDecorator;
import io.druid.query.Query;
import io.druid.query.QueryCacheHelper;
import io.druid.query.QueryDataSource;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.SubqueryQueryRunner;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.DimFilter;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryHelper;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexStorageAdapter;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class GroupByQueryQueryToolChest
extends QueryToolChest<Row, GroupByQuery> {
    private static final byte GROUPBY_QUERY = 20;
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<Row> TYPE_REFERENCE = new TypeReference<Row>(){};
    private static final String GROUP_BY_MERGE_KEY = "groupByMerge";
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final StupidPool<ByteBuffer> bufferPool;
    private final ObjectMapper jsonMapper;
    private GroupByQueryEngine engine;
    private final IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator;

    @Inject
    public GroupByQueryQueryToolChest(Supplier<GroupByQueryConfig> configSupplier, ObjectMapper jsonMapper, GroupByQueryEngine engine, @Global StupidPool<ByteBuffer> bufferPool, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator) {
        this.configSupplier = configSupplier;
        this.jsonMapper = jsonMapper;
        this.engine = engine;
        this.bufferPool = bufferPool;
        this.intervalChunkingQueryRunnerDecorator = intervalChunkingQueryRunnerDecorator;
    }

    @Override
    public QueryRunner<Row> mergeResults(final QueryRunner<Row> runner) {
        return new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(Query<Row> query, Map<String, Object> responseContext) {
                if (BaseQuery.getContextBySegment(query, false)) {
                    return runner.run(query, responseContext);
                }
                if (query.getContextBoolean(GroupByQueryQueryToolChest.GROUP_BY_MERGE_KEY, true)) {
                    return GroupByQueryQueryToolChest.this.mergeGroupByResults((GroupByQuery)query, runner, responseContext);
                }
                return runner.run(query, responseContext);
            }
        };
    }

    private Sequence<Row> mergeGroupByResults(GroupByQuery query, QueryRunner<Row> runner, Map<String, Object> context) {
        DataSource dataSource = query.getDataSource();
        if (dataSource instanceof QueryDataSource) {
            GroupByQuery subquery;
            try {
                subquery = (GroupByQuery)((QueryDataSource)dataSource).getQuery().withOverriddenContext(query.getContext());
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Subqueries must be of type 'group by'");
            }
            Sequence<Row> subqueryResult = this.mergeGroupByResults((GroupByQuery)subquery.withOverriddenContext((Map)ImmutableMap.of((Object)"sortResults", (Object)false)), runner, context);
            HashSet aggs = Sets.newHashSet();
            for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
                for (final AggregatorFactory transferAgg : aggregatorFactory.getRequiredColumns()) {
                    if (Iterables.any((Iterable)aggs, (Predicate)new Predicate<AggregatorFactory>(){

                        public boolean apply(AggregatorFactory agg) {
                            return agg.getName().equals(transferAgg.getName()) && !agg.equals(transferAgg);
                        }
                    })) {
                        throw new IAE("Inner aggregator can currently only be referenced by a single type of outer aggregator for '%s'", new Object[]{transferAgg.getName()});
                    }
                    aggs.add(transferAgg);
                }
            }
            GroupByQuery innerQuery = new GroupByQuery.Builder(subquery).setAggregatorSpecs(Lists.newArrayList((Iterable)aggs)).setInterval(subquery.getIntervals()).setPostAggregatorSpecs(Lists.newArrayList()).build();
            final GroupByQuery outerQuery = new GroupByQuery.Builder(query).setLimitSpec(query.getLimitSpec().merge(subquery.getLimitSpec())).build();
            final IncrementalIndex innerQueryResultIndex = this.makeIncrementalIndex((GroupByQuery)innerQuery.withOverriddenContext((Map)ImmutableMap.of((Object)"sortResults", (Object)true)), subqueryResult);
            IncrementalIndex outerQueryResultIndex = this.makeIncrementalIndex(outerQuery, (Sequence<Row>)Sequences.concat((Sequence)Sequences.map((Sequence)Sequences.simple(outerQuery.getIntervals()), (Function)new Function<Interval, Sequence<Row>>(){

                public Sequence<Row> apply(Interval interval) {
                    return GroupByQueryQueryToolChest.this.engine.process(outerQuery.withQuerySegmentSpec(new MultipleIntervalSegmentSpec((List<Interval>)ImmutableList.of((Object)interval))), new IncrementalIndexStorageAdapter(innerQueryResultIndex));
                }
            })));
            innerQueryResultIndex.close();
            return new ResourceClosingSequence(outerQuery.applyLimit(this.postAggregate(query, outerQueryResultIndex)), (Closeable)outerQueryResultIndex);
        }
        IncrementalIndex index = this.makeIncrementalIndex(query, runner.run(new GroupByQuery(query.getDataSource(), query.getQuerySegmentSpec(), query.getDimFilter(), query.getGranularity(), query.getDimensions(), query.getAggregatorSpecs(), (List<PostAggregator>)ImmutableList.of(), null, null, query.getContext()).withOverriddenContext((Map)ImmutableMap.of((Object)"finalize", (Object)false, (Object)"sortResults", (Object)false, (Object)GROUP_BY_MERGE_KEY, (Object)false)), context));
        return new ResourceClosingSequence(query.applyLimit(this.postAggregate(query, index)), (Closeable)index);
    }

    private Sequence<Row> postAggregate(final GroupByQuery query, IncrementalIndex index) {
        return Sequences.map((Sequence)Sequences.simple(index.iterableWithPostAggregations(query.getPostAggregatorSpecs(), query.isDescending())), (Function)new Function<Row, Row>(){

            public Row apply(Row input) {
                MapBasedRow row = (MapBasedRow)input;
                return new MapBasedRow(query.getGranularity().toDateTime(row.getTimestampFromEpoch()), row.getEvent());
            }
        });
    }

    private IncrementalIndex makeIncrementalIndex(GroupByQuery query, Sequence<Row> rows) {
        GroupByQueryConfig config = (GroupByQueryConfig)this.configSupplier.get();
        Pair indexAccumulatorPair = GroupByQueryHelper.createIndexAccumulatorPair(query, config, this.bufferPool);
        return (IncrementalIndex)rows.accumulate(indexAccumulatorPair.lhs, (Accumulator)indexAccumulatorPair.rhs);
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(GroupByQuery query) {
        return DruidMetrics.makePartialQueryTimeMetric(query).setDimension("numDimensions", String.valueOf(query.getDimensions().size())).setDimension("numMetrics", String.valueOf(query.getAggregatorSpecs().size())).setDimension("numComplexMetrics", String.valueOf(DruidMetrics.findNumComplexAggs(query.getAggregatorSpecs())));
    }

    @Override
    public Function<Row, Row> makePreComputeManipulatorFn(final GroupByQuery query, final MetricManipulationFn fn) {
        return new Function<Row, Row>(){

            public Row apply(Row input) {
                if (input instanceof MapBasedRow) {
                    MapBasedRow inputRow = (MapBasedRow)input;
                    HashMap values = Maps.newHashMap((Map)inputRow.getEvent());
                    for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                        values.put(agg.getName(), fn.manipulate(agg, inputRow.getEvent().get(agg.getName())));
                    }
                    return new MapBasedRow(inputRow.getTimestamp(), (Map)values);
                }
                return input;
            }
        };
    }

    @Override
    public Function<Row, Row> makePostComputeManipulatorFn(GroupByQuery query, MetricManipulationFn fn) {
        ImmutableSet optimizedDims = ImmutableSet.copyOf((Iterable)Iterables.transform(GroupByQueryQueryToolChest.extractionsToRewrite(query), (Function)new Function<DimensionSpec, String>(){

            public String apply(DimensionSpec input) {
                return input.getOutputName();
            }
        }));
        final Function<Row, Row> preCompute = this.makePreComputeManipulatorFn(query, fn);
        if (optimizedDims.isEmpty()) {
            return preCompute;
        }
        HashMap<String, ExtractionFn> extractionFnMap = new HashMap<String, ExtractionFn>();
        for (DimensionSpec dimensionSpec : query.getDimensions()) {
            String dimension = dimensionSpec.getOutputName();
            if (!optimizedDims.contains(dimension)) continue;
            extractionFnMap.put(dimension, dimensionSpec.getExtractionFn());
        }
        return new Function<Row, Row>((Set)optimizedDims, extractionFnMap){
            final /* synthetic */ Set val$optimizedDims;
            final /* synthetic */ Map val$extractionFnMap;
            {
                this.val$optimizedDims = set;
                this.val$extractionFnMap = map;
            }

            @Nullable
            public Row apply(Row input) {
                Row preRow = (Row)preCompute.apply((Object)input);
                if (preRow instanceof MapBasedRow) {
                    MapBasedRow preMapRow = (MapBasedRow)preRow;
                    HashMap event = Maps.newHashMap((Map)preMapRow.getEvent());
                    for (String dim : this.val$optimizedDims) {
                        Object eventVal = event.get(dim);
                        event.put(dim, ((ExtractionFn)this.val$extractionFnMap.get(dim)).apply(eventVal));
                    }
                    return new MapBasedRow(preMapRow.getTimestamp(), (Map)event);
                }
                return preRow;
            }
        };
    }

    @Override
    public TypeReference<Row> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public QueryRunner<Row> preMergeQueryDecoration(final QueryRunner<Row> runner) {
        return new SubqueryQueryRunner<Row>(this.intervalChunkingQueryRunnerDecorator.decorate(new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(Query<Row> query, Map<String, Object> responseContext) {
                GroupByQuery groupByQuery = (GroupByQuery)query;
                if (groupByQuery.getDimFilter() != null) {
                    groupByQuery = groupByQuery.withDimFilter(groupByQuery.getDimFilter().optimize());
                }
                GroupByQuery delegateGroupByQuery = groupByQuery;
                ArrayList<DimensionSpec> dimensionSpecs = new ArrayList<DimensionSpec>();
                ImmutableSet optimizedDimensions = ImmutableSet.copyOf((Iterable)Iterables.transform(GroupByQueryQueryToolChest.extractionsToRewrite(delegateGroupByQuery), (Function)new Function<DimensionSpec, String>(){

                    public String apply(DimensionSpec input) {
                        return input.getDimension();
                    }
                }));
                for (DimensionSpec dimensionSpec : delegateGroupByQuery.getDimensions()) {
                    if (optimizedDimensions.contains(dimensionSpec.getDimension())) {
                        dimensionSpecs.add(new DefaultDimensionSpec(dimensionSpec.getDimension(), dimensionSpec.getOutputName()));
                        continue;
                    }
                    dimensionSpecs.add(dimensionSpec);
                }
                return runner.run(delegateGroupByQuery.withDimensionSpecs(dimensionSpecs), responseContext);
            }
        }, this));
    }

    @Override
    public CacheStrategy<Row, Object, GroupByQuery> getCacheStrategy(final GroupByQuery query) {
        return new CacheStrategy<Row, Object, GroupByQuery>(){
            private static final byte CACHE_STRATEGY_VERSION = 1;
            private final List<AggregatorFactory> aggs;
            private final List<DimensionSpec> dims;
            {
                this.aggs = query.getAggregatorSpecs();
                this.dims = query.getDimensions();
            }

            @Override
            public byte[] computeCacheKey(GroupByQuery query2) {
                DimFilter dimFilter = query2.getDimFilter();
                byte[] filterBytes = dimFilter == null ? new byte[]{} : dimFilter.getCacheKey();
                byte[] aggregatorBytes = QueryCacheHelper.computeAggregatorBytes(query2.getAggregatorSpecs());
                byte[] granularityBytes = query2.getGranularity().cacheKey();
                byte[][] dimensionsBytes = new byte[query2.getDimensions().size()][];
                int dimensionsBytesSize = 0;
                int index = 0;
                for (DimensionSpec dimension : query2.getDimensions()) {
                    dimensionsBytes[index] = dimension.getCacheKey();
                    dimensionsBytesSize += dimensionsBytes[index].length;
                    ++index;
                }
                byte[] havingBytes = query2.getHavingSpec() == null ? new byte[]{} : query2.getHavingSpec().getCacheKey();
                byte[] limitBytes = query2.getLimitSpec().getCacheKey();
                ByteBuffer buffer = ByteBuffer.allocate(2 + granularityBytes.length + filterBytes.length + aggregatorBytes.length + dimensionsBytesSize + havingBytes.length + limitBytes.length).put((byte)20).put((byte)1).put(granularityBytes).put(filterBytes).put(aggregatorBytes);
                for (byte[] dimensionsByte : dimensionsBytes) {
                    buffer.put(dimensionsByte);
                }
                return buffer.put(havingBytes).put(limitBytes).array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Row, Object> prepareForCache() {
                return new Function<Row, Object>(){

                    public Object apply(Row input) {
                        if (input instanceof MapBasedRow) {
                            MapBasedRow row = (MapBasedRow)input;
                            ArrayList retVal = Lists.newArrayListWithCapacity((int)(1 + dims.size() + aggs.size()));
                            retVal.add(row.getTimestamp().getMillis());
                            Map event = row.getEvent();
                            for (DimensionSpec dim : dims) {
                                retVal.add(event.get(dim.getOutputName()));
                            }
                            for (AggregatorFactory agg : aggs) {
                                retVal.add(event.get(agg.getName()));
                            }
                            return retVal;
                        }
                        throw new ISE("Don't know how to cache input rows of type[%s]", new Object[]{input.getClass()});
                    }
                };
            }

            @Override
            public Function<Object, Row> pullFromCache() {
                return new Function<Object, Row>(){
                    private final QueryGranularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Row apply(Object input) {
                        Iterator results = ((List)input).iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)results.next()).longValue());
                        LinkedHashMap event = Maps.newLinkedHashMap();
                        Iterator dimsIter = dims.iterator();
                        while (dimsIter.hasNext() && results.hasNext()) {
                            DimensionSpec factory = (DimensionSpec)dimsIter.next();
                            event.put(factory.getOutputName(), results.next());
                        }
                        Iterator aggsIter = aggs.iterator();
                        while (aggsIter.hasNext() && results.hasNext()) {
                            AggregatorFactory factory = (AggregatorFactory)aggsIter.next();
                            event.put(factory.getName(), factory.deserialize(results.next()));
                        }
                        if (dimsIter.hasNext() || aggsIter.hasNext() || results.hasNext()) {
                            throw new ISE("Found left over objects while reading from cache!! dimsIter[%s] aggsIter[%s] results[%s]", new Object[]{dimsIter.hasNext(), aggsIter.hasNext(), results.hasNext()});
                        }
                        return new MapBasedRow(timestamp, (Map)event);
                    }
                };
            }
        };
    }

    public static Collection<DimensionSpec> extractionsToRewrite(GroupByQuery query) {
        return Collections2.filter(query.getDimensions(), (Predicate)new Predicate<DimensionSpec>(){

            public boolean apply(DimensionSpec input) {
                return input.getExtractionFn() != null && ExtractionFn.ExtractionType.ONE_TO_ONE.equals((Object)input.getExtractionFn().getExtractionType());
            }
        });
    }
}

