/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.druid.data.input.Row;
import io.druid.query.groupby.having.HavingSpec;
import java.nio.ByteBuffer;
import java.util.List;

public class OrHavingSpec
implements HavingSpec {
    private static final byte CACHE_KEY = 7;
    private List<HavingSpec> havingSpecs;

    @JsonCreator
    public OrHavingSpec(@JsonProperty(value="havingSpecs") List<HavingSpec> havingSpecs) {
        this.havingSpecs = havingSpecs == null ? ImmutableList.of() : havingSpecs;
    }

    @JsonProperty(value="havingSpecs")
    public List<HavingSpec> getHavingSpecs() {
        return this.havingSpecs;
    }

    @Override
    public boolean eval(Row row) {
        for (HavingSpec havingSpec : this.havingSpecs) {
            if (!havingSpec.eval(row)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] getCacheKey() {
        byte[][] havingBytes = new byte[this.havingSpecs.size()][];
        int havingBytesSize = 0;
        int index = 0;
        for (HavingSpec havingSpec : this.havingSpecs) {
            havingBytes[index] = havingSpec.getCacheKey();
            havingBytesSize += havingBytes[index].length;
            ++index;
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + havingBytesSize).put((byte)7);
        for (byte[] havingByte : havingBytes) {
            buffer.put(havingByte);
        }
        return buffer.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrHavingSpec that = (OrHavingSpec)o;
        return !(this.havingSpecs != null ? !this.havingSpecs.equals(that.havingSpecs) : that.havingSpecs != null);
    }

    public int hashCode() {
        return this.havingSpecs != null ? this.havingSpecs.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OrHavingSpec");
        sb.append("{havingSpecs=").append(this.havingSpecs);
        sb.append('}');
        return sb.toString();
    }
}

