/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.lookup;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Json;
import io.druid.query.lookup.LookupBean;
import io.druid.query.lookup.LookupConfig;
import io.druid.query.lookup.LookupExtractorFactory;
import io.druid.query.lookup.LookupSnapshotTaker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

@ManageLifecycle
public class LookupReferencesManager {
    private static final Logger LOGGER = new Logger(LookupReferencesManager.class);
    private final ConcurrentMap<String, LookupExtractorFactory> lookupMap = new ConcurrentHashMap<String, LookupExtractorFactory>();
    private final Object lock = new Object();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final LookupSnapshotTaker lookupSnapshotTaker;

    @Inject
    public LookupReferencesManager(LookupConfig lookupConfig, @Json ObjectMapper objectMapper) {
        this.lookupSnapshotTaker = Strings.isNullOrEmpty((String)lookupConfig.getSnapshotWorkingDir()) ? null : new LookupSnapshotTaker(objectMapper, lookupConfig.getSnapshotWorkingDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started.getAndSet(true)) {
                if (this.lookupSnapshotTaker != null) {
                    List<LookupBean> lookupBeanList = this.lookupSnapshotTaker.pullExistingSnapshot();
                    for (LookupBean lookupBean : lookupBeanList) {
                        this.put(lookupBean.name, lookupBean.factory);
                    }
                }
                LOGGER.info("Started lookup factory references manager", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started.getAndSet(false)) {
                if (this.lookupSnapshotTaker != null) {
                    this.lookupSnapshotTaker.takeSnapshot(this.getAllAsList());
                }
                LOGGER.info("Stopping lookup factory references manager", new Object[0]);
                for (String lookupName : this.lookupMap.keySet()) {
                    ((LookupExtractorFactory)this.lookupMap.remove(lookupName)).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String lookupName, LookupExtractorFactory lookupExtractorFactory) {
        Object object = this.lock;
        synchronized (object) {
            boolean noPrior;
            this.assertStarted();
            if (this.lookupMap.containsKey(lookupName)) {
                LOGGER.warn("lookup [%s] is not add, another lookup with the same name already exist", new Object[]{lookupName});
                return false;
            }
            if (!lookupExtractorFactory.start()) {
                throw new ISE("start method returned false for lookup [%s]", new Object[]{lookupName});
            }
            boolean bl = noPrior = null == this.lookupMap.putIfAbsent(lookupName, lookupExtractorFactory);
            if (noPrior) {
                if (this.lookupSnapshotTaker != null) {
                    this.lookupSnapshotTaker.takeSnapshot(this.getAllAsList());
                }
            } else if (!lookupExtractorFactory.close()) {
                throw new ISE("Error closing [%s] on race condition", new Object[]{lookupName});
            }
            return noPrior;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Map<String, LookupExtractorFactory> lookups) {
        HashMap<String, LookupExtractorFactory> failedExtractorFactoryMap = new HashMap<String, LookupExtractorFactory>();
        Object object = this.lock;
        synchronized (object) {
            this.assertStarted();
            for (Map.Entry<String, LookupExtractorFactory> entry : lookups.entrySet()) {
                String lookupName = entry.getKey();
                LookupExtractorFactory lookupExtractorFactory = entry.getValue();
                if (this.lookupMap.containsKey(lookupName)) {
                    LOGGER.warn("lookup [%s] is not add, another lookup with the same name already exist", new Object[]{lookupName});
                    continue;
                }
                if (!lookupExtractorFactory.start()) {
                    failedExtractorFactoryMap.put(lookupName, lookupExtractorFactory);
                    continue;
                }
                this.lookupMap.put(lookupName, lookupExtractorFactory);
                if (this.lookupSnapshotTaker == null) continue;
                this.lookupSnapshotTaker.takeSnapshot(this.getAllAsList());
            }
            if (!failedExtractorFactoryMap.isEmpty()) {
                throw new ISE("was not able to start the following lookup(s) [%s]", new Object[]{failedExtractorFactoryMap.keySet().toString()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateIfNew(String lookupName, LookupExtractorFactory lookupExtractorFactory) {
        boolean update;
        Object object = this.lock;
        synchronized (object) {
            this.assertStarted();
            LookupExtractorFactory prior = (LookupExtractorFactory)this.lookupMap.get(lookupName);
            update = lookupExtractorFactory.replaces(prior);
            if (update) {
                if (!lookupExtractorFactory.start()) {
                    throw new ISE("Could not start [%s]", new Object[]{lookupName});
                }
                this.lookupMap.put(lookupName, lookupExtractorFactory);
                if (prior != null && !prior.close()) {
                    LOGGER.error("Error closing [%s]:[%s]", new Object[]{lookupName, lookupExtractorFactory});
                }
            }
        }
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String lookupName) {
        Object object = this.lock;
        synchronized (object) {
            LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)this.lookupMap.remove(lookupName);
            if (lookupExtractorFactory != null) {
                LOGGER.debug("Removed lookup [%s]", new Object[]{lookupName});
                if (this.lookupSnapshotTaker != null) {
                    this.lookupSnapshotTaker.takeSnapshot(this.getAllAsList());
                }
                return lookupExtractorFactory.close();
            }
        }
        return false;
    }

    @Nullable
    public LookupExtractorFactory get(String lookupName) {
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)this.lookupMap.get(lookupName);
        this.assertStarted();
        return lookupExtractorFactory;
    }

    public Map<String, LookupExtractorFactory> getAll() {
        this.assertStarted();
        return Maps.newHashMap(this.lookupMap);
    }

    private void assertStarted() throws ISE {
        if (this.isClosed()) {
            throw new ISE("lookup manager is closed", new Object[0]);
        }
    }

    public boolean isClosed() {
        return !this.started.get();
    }

    private List<LookupBean> getAllAsList() {
        return Lists.newArrayList((Iterable)Collections2.transform(this.lookupMap.entrySet(), (Function)new Function<Map.Entry<String, LookupExtractorFactory>, LookupBean>(){

            @Nullable
            public LookupBean apply(@Nullable Map.Entry<String, LookupExtractorFactory> input) {
                LookupBean lookupBean = new LookupBean();
                lookupBean.factory = input.getValue();
                lookupBean.name = input.getKey();
                return lookupBean;
            }
        }));
    }
}

