/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.lookup;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.guice.annotations.Json;
import io.druid.query.lookup.LookupBean;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class LookupSnapshotTaker {
    private static final Logger LOGGER = new Logger(LookupSnapshotTaker.class);
    protected static final String PERSIST_FILE_NAME = "lookupSnapshot.json";
    private final ObjectMapper objectMapper;
    private final File persistDirectory;
    private final File persistFile;

    public LookupSnapshotTaker(@Json ObjectMapper jsonMapper, String persistDirectory) {
        this.objectMapper = jsonMapper;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)persistDirectory) ? 1 : 0) != 0, (Object)"can not work without specifying persistDirectory");
        this.persistDirectory = new File(persistDirectory);
        if (!this.persistDirectory.exists()) {
            Preconditions.checkArgument((boolean)this.persistDirectory.mkdirs(), (Object)"Oups was not able to create persist directory");
        }
        if (!this.persistDirectory.isDirectory()) {
            throw new ISE("Can only persist to directories, [%s] wasn't a directory", new Object[]{persistDirectory});
        }
        this.persistFile = new File(persistDirectory, PERSIST_FILE_NAME);
    }

    public synchronized List<LookupBean> pullExistingSnapshot() {
        try {
            if (!this.persistFile.isFile()) {
                LOGGER.warn("could not find any snapshot file under working directory [%s]", new Object[]{this.persistDirectory});
                return Collections.emptyList();
            }
            if (this.persistFile.length() == 0L) {
                LOGGER.warn("found empty file no lookups to load from [%s]", new Object[]{this.persistFile.getAbsolutePath()});
                return Collections.emptyList();
            }
            List lookupBeanList = (List)this.objectMapper.readValue(this.persistFile, (TypeReference)new TypeReference<List<LookupBean>>(){});
            return lookupBeanList;
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Exception during reading lookups from [%s]", new Object[]{this.persistFile.getAbsolutePath()});
        }
    }

    public synchronized void takeSnapshot(List<LookupBean> lookups) {
        try {
            this.objectMapper.writeValue(this.persistFile, lookups);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Exception during serialization of lookups using file [%s]", new Object[]{this.persistFile.getAbsolutePath()});
        }
    }

    public File getPersistFile() {
        return this.persistFile;
    }
}

