/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.guava.MappedSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.common.guava.CombiningSequence;
import io.druid.common.utils.JodaUtils;
import io.druid.granularity.QueryGranularity;
import io.druid.query.CacheStrategy;
import io.druid.query.DruidMetrics;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.ResultMergeQueryRunner;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.metadata.SegmentMetadataQueryConfig;
import io.druid.query.metadata.metadata.ColumnAnalysis;
import io.druid.query.metadata.metadata.SegmentAnalysis;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import io.druid.timeline.LogicalSegment;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

public class SegmentMetadataQueryQueryToolChest
extends QueryToolChest<SegmentAnalysis, SegmentMetadataQuery> {
    private static final TypeReference<SegmentAnalysis> TYPE_REFERENCE = new TypeReference<SegmentAnalysis>(){};
    private static final byte[] SEGMENT_METADATA_CACHE_PREFIX = new byte[]{4};
    private static final Function<SegmentAnalysis, SegmentAnalysis> MERGE_TRANSFORM_FN = new Function<SegmentAnalysis, SegmentAnalysis>(){

        public SegmentAnalysis apply(SegmentAnalysis analysis) {
            return SegmentMetadataQueryQueryToolChest.finalizeAnalysis(analysis);
        }
    };
    private final SegmentMetadataQueryConfig config;

    @Inject
    public SegmentMetadataQueryQueryToolChest(SegmentMetadataQueryConfig config) {
        this.config = config;
    }

    @Override
    public QueryRunner<SegmentAnalysis> mergeResults(QueryRunner<SegmentAnalysis> runner) {
        return new ResultMergeQueryRunner<SegmentAnalysis>(runner){

            @Override
            public Sequence<SegmentAnalysis> doRun(QueryRunner<SegmentAnalysis> baseRunner, Query<SegmentAnalysis> query, Map<String, Object> context) {
                return new MappedSequence((Sequence)CombiningSequence.create(baseRunner.run(query, context), this.makeOrdering(query), this.createMergeFn(query)), MERGE_TRANSFORM_FN);
            }

            @Override
            protected Ordering<SegmentAnalysis> makeOrdering(Query<SegmentAnalysis> query) {
                if (((SegmentMetadataQuery)query).isMerge()) {
                    return new Ordering<SegmentAnalysis>(){

                        public int compare(@Nullable SegmentAnalysis left, @Nullable SegmentAnalysis right) {
                            return 0;
                        }
                    };
                }
                return query.getResultOrdering();
            }

            @Override
            protected BinaryFn<SegmentAnalysis, SegmentAnalysis, SegmentAnalysis> createMergeFn(final Query<SegmentAnalysis> inQ) {
                return new BinaryFn<SegmentAnalysis, SegmentAnalysis, SegmentAnalysis>(){
                    private final SegmentMetadataQuery query;
                    {
                        this.query = (SegmentMetadataQuery)inQ;
                    }

                    public SegmentAnalysis apply(SegmentAnalysis arg1, SegmentAnalysis arg2) {
                        return SegmentMetadataQueryQueryToolChest.mergeAnalyses(arg1, arg2, this.query.isLenientAggregatorMerge());
                    }
                };
            }
        };
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(SegmentMetadataQuery query) {
        return DruidMetrics.makePartialQueryTimeMetric(query);
    }

    @Override
    public Function<SegmentAnalysis, SegmentAnalysis> makePreComputeManipulatorFn(SegmentMetadataQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<SegmentAnalysis> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<SegmentAnalysis, SegmentAnalysis, SegmentMetadataQuery> getCacheStrategy(SegmentMetadataQuery query) {
        return new CacheStrategy<SegmentAnalysis, SegmentAnalysis, SegmentMetadataQuery>(){

            @Override
            public byte[] computeCacheKey(SegmentMetadataQuery query) {
                byte[] includerBytes = query.getToInclude().getCacheKey();
                byte[] analysisTypesBytes = query.getAnalysisTypesCacheKey();
                return ByteBuffer.allocate(1 + includerBytes.length + analysisTypesBytes.length).put(SEGMENT_METADATA_CACHE_PREFIX).put(includerBytes).put(analysisTypesBytes).array();
            }

            @Override
            public TypeReference<SegmentAnalysis> getCacheObjectClazz() {
                return SegmentMetadataQueryQueryToolChest.this.getResultTypeReference();
            }

            @Override
            public Function<SegmentAnalysis, SegmentAnalysis> prepareForCache() {
                return new Function<SegmentAnalysis, SegmentAnalysis>(){

                    public SegmentAnalysis apply(@Nullable SegmentAnalysis input) {
                        return input;
                    }
                };
            }

            @Override
            public Function<SegmentAnalysis, SegmentAnalysis> pullFromCache() {
                return new Function<SegmentAnalysis, SegmentAnalysis>(){

                    public SegmentAnalysis apply(@Nullable SegmentAnalysis input) {
                        return input;
                    }
                };
            }
        };
    }

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(SegmentMetadataQuery query, List<T> segments) {
        if (!query.isUsingDefaultInterval()) {
            return segments;
        }
        if (segments.size() <= 1) {
            return segments;
        }
        LogicalSegment max = (LogicalSegment)segments.get(segments.size() - 1);
        DateTime targetEnd = max.getInterval().getEnd();
        final Interval targetInterval = new Interval((ReadablePeriod)this.config.getDefaultHistory(), (ReadableInstant)targetEnd);
        return Lists.newArrayList((Iterable)Iterables.filter(segments, (Predicate)new Predicate<T>(){

            public boolean apply(T input) {
                return input.getInterval().overlaps((ReadableInterval)targetInterval);
            }
        }));
    }

    @VisibleForTesting
    public static SegmentAnalysis mergeAnalyses(SegmentAnalysis arg1, SegmentAnalysis arg2, boolean lenientAggregatorMerge) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        ArrayList newIntervals = null;
        if (arg1.getIntervals() != null) {
            newIntervals = Lists.newArrayList();
            newIntervals.addAll(arg1.getIntervals());
        }
        if (arg2.getIntervals() != null) {
            if (newIntervals == null) {
                newIntervals = Lists.newArrayList();
            }
            newIntervals.addAll(arg2.getIntervals());
        }
        Map<String, ColumnAnalysis> leftColumns = arg1.getColumns();
        Map<String, ColumnAnalysis> rightColumns = arg2.getColumns();
        TreeMap columns = Maps.newTreeMap();
        HashSet rightColumnNames = Sets.newHashSet(rightColumns.keySet());
        for (Map.Entry<String, ColumnAnalysis> entry : leftColumns.entrySet()) {
            String columnName = entry.getKey();
            columns.put(columnName, entry.getValue().fold(rightColumns.get(columnName)));
            rightColumnNames.remove(columnName);
        }
        for (String columnName : rightColumnNames) {
            columns.put(columnName, rightColumns.get(columnName));
        }
        HashMap aggregators = Maps.newHashMap();
        if (lenientAggregatorMerge) {
            for (SegmentAnalysis analysis : ImmutableList.of((Object)arg1, (Object)arg2)) {
                if (analysis.getAggregators() == null) continue;
                for (AggregatorFactory aggregator : analysis.getAggregators().values()) {
                    AggregatorFactory merged = (AggregatorFactory)aggregators.get(aggregator.getName());
                    if (merged != null) {
                        try {
                            merged = merged.getMergingFactory(aggregator);
                        }
                        catch (AggregatorFactoryNotMergeableException e) {
                            merged = null;
                        }
                    } else {
                        merged = aggregator;
                    }
                    aggregators.put(aggregator.getName(), merged);
                }
            }
        } else {
            AggregatorFactory[] aggs2;
            AggregatorFactory[] aggs1 = arg1.getAggregators() != null ? arg1.getAggregators().values().toArray(new AggregatorFactory[arg1.getAggregators().size()]) : null;
            AggregatorFactory[] merged = AggregatorFactory.mergeAggregators(Arrays.asList(aggs1, aggs2 = arg2.getAggregators() != null ? arg2.getAggregators().values().toArray(new AggregatorFactory[arg2.getAggregators().size()]) : null));
            if (merged != null) {
                for (AggregatorFactory aggregator : merged) {
                    aggregators.put(aggregator.getName(), aggregator);
                }
            }
        }
        QueryGranularity queryGranularity = QueryGranularity.mergeQueryGranularities(Lists.newArrayList((Object[])new QueryGranularity[]{arg1.getQueryGranularity(), arg2.getQueryGranularity()}));
        String mergedId = arg1.getId() != null && arg2.getId() != null && arg1.getId().equals(arg2.getId()) ? arg1.getId() : "merged";
        return new SegmentAnalysis(mergedId, newIntervals, columns, arg1.getSize() + arg2.getSize(), arg1.getNumRows() + arg2.getNumRows(), aggregators.isEmpty() ? null : aggregators, queryGranularity);
    }

    @VisibleForTesting
    public static SegmentAnalysis finalizeAnalysis(SegmentAnalysis analysis) {
        return new SegmentAnalysis(analysis.getId(), analysis.getIntervals() != null ? JodaUtils.condenseIntervals(analysis.getIntervals()) : null, analysis.getColumns(), analysis.getSize(), analysis.getNumRows(), analysis.getAggregators(), analysis.getQueryGranularity());
    }
}

