/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.common.ISE;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.emitter.EmittingLogger;
import io.druid.granularity.QueryGranularities;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.IdentityExtractionFn;
import io.druid.query.filter.Filter;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.SearchHit;
import io.druid.query.search.search.SearchQuery;
import io.druid.query.search.search.SearchQuerySpec;
import io.druid.segment.ColumnSelectorBitmapIndexSelector;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.QueryableIndex;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.Column;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.Filters;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.mutable.MutableInt;

public class SearchQueryRunner
implements QueryRunner<Result<SearchResultValue>> {
    private static final EmittingLogger log = new EmittingLogger(SearchQueryRunner.class);
    private final Segment segment;

    public SearchQueryRunner(Segment segment) {
        this.segment = segment;
    }

    @Override
    public Sequence<Result<SearchResultValue>> run(Query<Result<SearchResultValue>> input, Map<String, Object> responseContext) {
        if (!(input instanceof SearchQuery)) {
            throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), SearchQuery.class});
        }
        SearchQuery query = (SearchQuery)input;
        Filter filter = Filters.toFilter(query.getDimensionsFilter());
        List<DimensionSpec> dimensions = query.getDimensions();
        final SearchQuerySpec searchQuerySpec = query.getQuery();
        final int limit = query.getLimit();
        boolean descending = query.isDescending();
        QueryableIndex index = this.segment.asQueryableIndex();
        if (index != null) {
            TreeMap retVal = Maps.newTreeMap(query.getSort().getComparator());
            Iterable<DimensionSpec> dimsToSearch = dimensions == null || dimensions.isEmpty() ? Iterables.transform(index.getAvailableDimensions(), Druids.DIMENSION_IDENTITY) : dimensions;
            BitmapFactory bitmapFactory = index.getBitmapFactoryForDimensions();
            ImmutableBitmap baseFilter = filter == null ? null : filter.getBitmapIndex(new ColumnSelectorBitmapIndexSelector(bitmapFactory, index));
            for (DimensionSpec dimension : dimsToSearch) {
                Column column = index.getColumn(dimension.getDimension());
                if (column == null) continue;
                BitmapIndex bitmapIndex = column.getBitmapIndex();
                ExtractionFn extractionFn = dimension.getExtractionFn();
                if (extractionFn == null) {
                    extractionFn = IdentityExtractionFn.getInstance();
                }
                if (bitmapIndex == null) continue;
                for (int i = 0; i < bitmapIndex.getCardinality(); ++i) {
                    String dimVal = Strings.nullToEmpty((String)extractionFn.apply(bitmapIndex.getValue(i)));
                    if (!searchQuerySpec.accept(dimVal)) continue;
                    ImmutableBitmap bitmap = bitmapIndex.getBitmap(i);
                    if (baseFilter != null) {
                        bitmap = bitmapFactory.intersection(Arrays.asList(baseFilter, bitmap));
                    }
                    if (bitmap.size() <= 0) continue;
                    MutableInt counter = new MutableInt(bitmap.size());
                    MutableInt prev = retVal.put(new SearchHit(dimension.getOutputName(), dimVal), counter);
                    if (prev != null) {
                        counter.add(prev.intValue());
                    }
                    if (retVal.size() < limit) continue;
                    return this.makeReturnResult(limit, retVal);
                }
            }
            return this.makeReturnResult(limit, retVal);
        }
        StorageAdapter adapter = this.segment.asStorageAdapter();
        if (adapter == null) {
            log.makeAlert("WTF!? Unable to process search query on segment.", new Object[0]).addData("segment", (Object)this.segment.getIdentifier()).addData("query", (Object)query).emit();
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        final Iterable<DimensionSpec> dimsToSearch = dimensions == null || dimensions.isEmpty() ? Iterables.transform(adapter.getAvailableDimensions(), Druids.DIMENSION_IDENTITY) : dimensions;
        Sequence<Cursor> cursors = adapter.makeCursors(filter, this.segment.getDataInterval(), QueryGranularities.ALL, descending);
        TreeMap retVal = (TreeMap)cursors.accumulate((Object)Maps.newTreeMap(query.getSort().getComparator()), (Accumulator)new Accumulator<TreeMap<SearchHit, MutableInt>, Cursor>(){

            public TreeMap<SearchHit, MutableInt> accumulate(TreeMap<SearchHit, MutableInt> set, Cursor cursor) {
                if (set.size() >= limit) {
                    return set;
                }
                HashMap dimSelectors = Maps.newHashMap();
                for (DimensionSpec dimensionSpec : dimsToSearch) {
                    dimSelectors.put(dimensionSpec.getOutputName(), cursor.makeDimensionSelector(dimensionSpec));
                }
                while (!cursor.isDone()) {
                    for (Map.Entry entry : dimSelectors.entrySet()) {
                        DimensionSelector selector = (DimensionSelector)entry.getValue();
                        if (selector == null) continue;
                        IndexedInts vals = selector.getRow();
                        for (int i = 0; i < vals.size(); ++i) {
                            String dimVal = selector.lookupName(vals.get(i));
                            if (!searchQuerySpec.accept(dimVal)) continue;
                            MutableInt counter = new MutableInt(1);
                            MutableInt prev = set.put(new SearchHit((String)entry.getKey(), dimVal), counter);
                            if (prev != null) {
                                counter.add(prev.intValue());
                            }
                            if (set.size() < limit) continue;
                            return set;
                        }
                    }
                    cursor.advance();
                }
                return set;
            }
        });
        return this.makeReturnResult(limit, retVal);
    }

    private Sequence<Result<SearchResultValue>> makeReturnResult(int limit, TreeMap<SearchHit, MutableInt> retVal) {
        Iterable source = Iterables.transform(retVal.entrySet(), (Function)new Function<Map.Entry<SearchHit, MutableInt>, SearchHit>(){

            public SearchHit apply(Map.Entry<SearchHit, MutableInt> input) {
                SearchHit hit = input.getKey();
                return new SearchHit(hit.getDimension(), hit.getValue(), input.getValue().intValue());
            }
        });
        return Sequences.simple((Iterable)ImmutableList.of(new Result<SearchResultValue>(this.segment.getDataInterval().getStart(), new SearchResultValue(Lists.newArrayList((Iterable)new FunctionalIterable(source).limit(limit))))));
    }
}

