/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.druid.granularity.QueryGranularity;
import io.druid.query.BaseQuery;
import io.druid.query.DataSource;
import io.druid.query.Queries;
import io.druid.query.Query;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.topn.TopNAlgorithmSelector;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.query.topn.TopNResultValue;
import java.util.List;
import java.util.Map;

public class TopNQuery
extends BaseQuery<Result<TopNResultValue>> {
    public static final String TOPN = "topN";
    private final DimensionSpec dimensionSpec;
    private final TopNMetricSpec topNMetricSpec;
    private final int threshold;
    private final DimFilter dimFilter;
    private final QueryGranularity granularity;
    private final List<AggregatorFactory> aggregatorSpecs;
    private final List<PostAggregator> postAggregatorSpecs;

    @JsonCreator
    public TopNQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="dimension") DimensionSpec dimensionSpec, @JsonProperty(value="metric") TopNMetricSpec topNMetricSpec, @JsonProperty(value="threshold") int threshold, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") QueryGranularity granularity, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregatorSpecs, @JsonProperty(value="postAggregations") List<PostAggregator> postAggregatorSpecs, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, false, context);
        this.dimensionSpec = dimensionSpec;
        this.topNMetricSpec = topNMetricSpec;
        this.threshold = threshold;
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.aggregatorSpecs = aggregatorSpecs;
        this.postAggregatorSpecs = postAggregatorSpecs == null ? ImmutableList.of() : postAggregatorSpecs;
        Preconditions.checkNotNull((Object)dimensionSpec, (Object)"dimensionSpec can't be null");
        Preconditions.checkNotNull((Object)topNMetricSpec, (Object)"must specify a metric");
        Preconditions.checkArgument((threshold != 0 ? 1 : 0) != 0, (Object)"Threshold cannot be equal to 0.");
        topNMetricSpec.verifyPreconditions(this.aggregatorSpecs, this.postAggregatorSpecs);
        Queries.verifyAggregations(this.aggregatorSpecs, this.postAggregatorSpecs);
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public String getType() {
        return TOPN;
    }

    @JsonProperty(value="dimension")
    public DimensionSpec getDimensionSpec() {
        return this.dimensionSpec;
    }

    @JsonProperty(value="metric")
    public TopNMetricSpec getTopNMetricSpec() {
        return this.topNMetricSpec;
    }

    @JsonProperty(value="threshold")
    public int getThreshold() {
        return this.threshold;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public QueryGranularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    @JsonProperty(value="postAggregations")
    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    public void initTopNAlgorithmSelector(TopNAlgorithmSelector selector) {
        if (this.dimensionSpec.getExtractionFn() != null) {
            selector.setHasExtractionFn(true);
        }
        this.topNMetricSpec.initTopNAlgorithmSelector(selector);
    }

    public TopNQuery withQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
        return new TopNQuery(this.getDataSource(), this.dimensionSpec, this.topNMetricSpec, this.threshold, querySegmentSpec, this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.getContext());
    }

    public TopNQuery withDimensionSpec(DimensionSpec spec) {
        return new TopNQuery(this.getDataSource(), spec, this.topNMetricSpec, this.threshold, this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.getContext());
    }

    public TopNQuery withPostAggregatorSpecs(List<PostAggregator> postAggregatorSpecs) {
        return new TopNQuery(this.getDataSource(), this.getDimensionSpec(), this.topNMetricSpec, this.threshold, this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.aggregatorSpecs, postAggregatorSpecs, this.getContext());
    }

    @Override
    public Query<Result<TopNResultValue>> withDataSource(DataSource dataSource) {
        return new TopNQuery(dataSource, this.dimensionSpec, this.topNMetricSpec, this.threshold, this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.getContext());
    }

    public TopNQuery withThreshold(int threshold) {
        return new TopNQuery(this.getDataSource(), this.dimensionSpec, this.topNMetricSpec, threshold, this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.getContext());
    }

    public TopNQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        return new TopNQuery(this.getDataSource(), this.dimensionSpec, this.topNMetricSpec, this.threshold, this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.computeOverridenContext(contextOverrides));
    }

    public TopNQuery withDimFilter(DimFilter dimFilter) {
        return new TopNQuery(this.getDataSource(), this.getDimensionSpec(), this.topNMetricSpec, this.threshold, this.getQuerySegmentSpec(), dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.getContext());
    }

    public String toString() {
        return "TopNQuery{dataSource='" + this.getDataSource() + '\'' + ", dimensionSpec=" + this.dimensionSpec + ", topNMetricSpec=" + this.topNMetricSpec + ", threshold=" + this.threshold + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", dimFilter=" + this.dimFilter + ", granularity='" + this.granularity + '\'' + ", aggregatorSpecs=" + this.aggregatorSpecs + ", postAggregatorSpecs=" + this.postAggregatorSpecs + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopNQuery topNQuery = (TopNQuery)o;
        if (this.threshold != topNQuery.threshold) {
            return false;
        }
        if (this.aggregatorSpecs != null ? !this.aggregatorSpecs.equals(topNQuery.aggregatorSpecs) : topNQuery.aggregatorSpecs != null) {
            return false;
        }
        if (this.dimFilter != null ? !this.dimFilter.equals(topNQuery.dimFilter) : topNQuery.dimFilter != null) {
            return false;
        }
        if (this.dimensionSpec != null ? !this.dimensionSpec.equals(topNQuery.dimensionSpec) : topNQuery.dimensionSpec != null) {
            return false;
        }
        if (this.granularity != null ? !this.granularity.equals(topNQuery.granularity) : topNQuery.granularity != null) {
            return false;
        }
        if (this.postAggregatorSpecs != null ? !this.postAggregatorSpecs.equals(topNQuery.postAggregatorSpecs) : topNQuery.postAggregatorSpecs != null) {
            return false;
        }
        return !(this.topNMetricSpec != null ? !this.topNMetricSpec.equals(topNQuery.topNMetricSpec) : topNQuery.topNMetricSpec != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dimensionSpec != null ? this.dimensionSpec.hashCode() : 0);
        result = 31 * result + (this.topNMetricSpec != null ? this.topNMetricSpec.hashCode() : 0);
        result = 31 * result + this.threshold;
        result = 31 * result + (this.dimFilter != null ? this.dimFilter.hashCode() : 0);
        result = 31 * result + (this.granularity != null ? this.granularity.hashCode() : 0);
        result = 31 * result + (this.aggregatorSpecs != null ? this.aggregatorSpecs.hashCode() : 0);
        result = 31 * result + (this.postAggregatorSpecs != null ? this.postAggregatorSpecs.hashCode() : 0);
        return result;
    }
}

