/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.segment.AbstractSegment;
import io.druid.segment.QueryableIndex;
import io.druid.segment.StorageAdapter;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexStorageAdapter;
import java.io.IOException;
import org.joda.time.Interval;

public class IncrementalIndexSegment
extends AbstractSegment {
    private final IncrementalIndex index;
    private final String segmentIdentifier;

    public IncrementalIndexSegment(IncrementalIndex index, String segmentIdentifier) {
        this.index = index;
        this.segmentIdentifier = segmentIdentifier;
    }

    @Override
    public String getIdentifier() {
        return this.segmentIdentifier;
    }

    @Override
    public Interval getDataInterval() {
        return this.index.getInterval();
    }

    @Override
    public QueryableIndex asQueryableIndex() {
        return null;
    }

    @Override
    public StorageAdapter asStorageAdapter() {
        return new IncrementalIndexStorageAdapter(this.index);
    }

    @Override
    public void close() throws IOException {
        this.index.close();
    }
}

