/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.segment.GenericColumnSerializer;
import io.druid.segment.IndexIO;
import io.druid.segment.data.CompressedLongsSupplierSerializer;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.IOPeon;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class LongColumnSerializer
implements GenericColumnSerializer {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ByteOrder byteOrder;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private CompressedLongsSupplierSerializer writer;

    public static LongColumnSerializer create(IOPeon ioPeon, String filenameBase, CompressedObjectStrategy.CompressionStrategy compression) {
        return new LongColumnSerializer(ioPeon, filenameBase, IndexIO.BYTE_ORDER, compression);
    }

    public LongColumnSerializer(IOPeon ioPeon, String filenameBase, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.byteOrder = byteOrder;
        this.compression = compression;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressedLongsSupplierSerializer.create(this.ioPeon, String.format("%s.long_column", this.filenameBase), this.byteOrder, this.compression);
        this.writer.open();
    }

    @Override
    public void serialize(Object obj) throws IOException {
        long val = obj == null ? 0L : ((Number)obj).longValue();
        this.writer.add(val);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public long getSerializedSize() {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        this.writer.writeToChannel(channel);
    }
}

