/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Metadata {
    @JsonProperty
    private final Map<String, Object> container = new ConcurrentHashMap<String, Object>();
    @JsonProperty
    private AggregatorFactory[] aggregators;
    @JsonProperty
    private QueryGranularity queryGranularity;

    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    public Metadata setAggregators(AggregatorFactory[] aggregators) {
        this.aggregators = aggregators;
        return this;
    }

    public QueryGranularity getQueryGranularity() {
        return this.queryGranularity;
    }

    public Metadata setQueryGranularity(QueryGranularity queryGranularity) {
        this.queryGranularity = queryGranularity;
        return this;
    }

    public Metadata putAll(Map<String, Object> other) {
        if (other != null) {
            this.container.putAll(other);
        }
        return this;
    }

    public Object get(String key) {
        return this.container.get(key);
    }

    public Metadata put(String key, Object value) {
        if (value != null) {
            this.container.put(key, value);
        }
        return this;
    }

    public static Metadata merge(List<Metadata> toBeMerged, AggregatorFactory[] overrideMergedAggregators) {
        if (toBeMerged == null || toBeMerged.size() == 0) {
            return null;
        }
        boolean foundSomeMetadata = false;
        HashMap<String, Object> mergedContainer = new HashMap<String, Object>();
        ArrayList<AggregatorFactory[]> aggregatorsToMerge = overrideMergedAggregators == null ? new ArrayList<AggregatorFactory[]>() : null;
        ArrayList<QueryGranularity> gransToMerge = new ArrayList<QueryGranularity>();
        for (Metadata metadata : toBeMerged) {
            if (metadata != null) {
                foundSomeMetadata = true;
                if (aggregatorsToMerge != null) {
                    aggregatorsToMerge.add(metadata.getAggregators());
                }
                if (gransToMerge != null) {
                    gransToMerge.add(metadata.getQueryGranularity());
                }
                mergedContainer.putAll(metadata.container);
                continue;
            }
            aggregatorsToMerge = null;
            gransToMerge = null;
        }
        if (!foundSomeMetadata) {
            return null;
        }
        Metadata result = new Metadata();
        if (aggregatorsToMerge != null) {
            result.setAggregators(AggregatorFactory.mergeAggregators(aggregatorsToMerge));
        } else {
            result.setAggregators(overrideMergedAggregators);
        }
        if (gransToMerge != null) {
            result.setQueryGranularity(QueryGranularity.mergeQueryGranularities(gransToMerge));
        }
        result.container.putAll(mergedContainer);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        if (!this.container.equals(metadata.container)) {
            return false;
        }
        if (!Arrays.equals(this.aggregators, metadata.aggregators)) {
            return false;
        }
        return !(this.queryGranularity == null ? metadata.queryGranularity != null : !this.queryGranularity.equals(metadata.queryGranularity));
    }

    public int hashCode() {
        int result = this.container.hashCode();
        result = 31 * result + (this.aggregators != null ? Arrays.hashCode(this.aggregators) : 0);
        result = 31 * result + (this.queryGranularity != null ? this.queryGranularity.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Metadata{container=" + this.container + ", aggregators=" + Arrays.toString(this.aggregators) + ", queryGranularity=" + this.queryGranularity + '}';
    }
}

