/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.common.logger.Logger;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.Metadata;
import io.druid.segment.Rowboat;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.data.EmptyIndexedInts;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.ListIndexed;
import io.druid.segment.incremental.IncrementalIndex;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.Interval;
import org.roaringbitmap.IntIterator;

public class IncrementalIndexAdapter
implements IndexableAdapter {
    private static final Logger log = new Logger(IncrementalIndexAdapter.class);
    private final Interval dataInterval;
    private final IncrementalIndex<?> index;
    private final Set<String> hasNullValueDimensions;
    private final Map<String, DimensionIndexer> indexers;

    public IncrementalIndexAdapter(Interval dataInterval, IncrementalIndex<?> index, BitmapFactory bitmapFactory) {
        this.dataInterval = dataInterval;
        this.index = index;
        this.hasNullValueDimensions = Sets.newHashSet();
        List<IncrementalIndex.DimensionDesc> dimensions = index.getDimensions();
        this.indexers = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        for (IncrementalIndex.DimensionDesc dimension : dimensions) {
            this.indexers.put(dimension.getName(), new DimensionIndexer(dimension));
        }
        int rowNum = 0;
        for (IncrementalIndex.TimeAndDims timeAndDims : index.getFacts().keySet()) {
            int[][] dims = timeAndDims.getDims();
            for (IncrementalIndex.DimensionDesc dimension : dimensions) {
                int dimIndex = dimension.getIndex();
                DimensionIndexer indexer = this.indexers.get(dimension.getName());
                if (dimIndex >= dims.length || dims[dimIndex] == null) {
                    this.hasNullValueDimensions.add(dimension.getName());
                    continue;
                }
                IncrementalIndex.DimDim values = dimension.getValues();
                if (this.hasNullValue(values, dims[dimIndex])) {
                    this.hasNullValueDimensions.add(dimension.getName());
                }
                MutableBitmap[] bitmapIndexes = indexer.invertedIndexes;
                int[] nArray = dims[dimIndex];
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer dimIdxComparable = nArray[i];
                    Integer dimIdx = dimIdxComparable;
                    if (bitmapIndexes[dimIdx] == null) {
                        bitmapIndexes[dimIdx.intValue()] = bitmapFactory.makeEmptyMutableBitmap();
                    }
                    bitmapIndexes[dimIdx].add(rowNum);
                }
            }
            ++rowNum;
        }
    }

    @Override
    public Interval getDataInterval() {
        return this.dataInterval;
    }

    @Override
    public int getNumRows() {
        return this.index.size();
    }

    @Override
    public Indexed<String> getDimensionNames() {
        return new ListIndexed<String>(this.index.getDimensionNames(), String.class);
    }

    @Override
    public Indexed<String> getMetricNames() {
        return new ListIndexed<String>(this.index.getMetricNames(), String.class);
    }

    @Override
    public Indexed<String> getDimValueLookup(String dimension) {
        DimensionIndexer indexer = this.indexers.get(dimension);
        if (indexer == null) {
            return null;
        }
        final IncrementalIndex.DimDim dimDim = indexer.getDimValues();
        final IncrementalIndex.SortedDimLookup dimLookup = indexer.getDimLookup();
        return new Indexed<String>(){

            @Override
            public Class<? extends String> getClazz() {
                return String.class;
            }

            @Override
            public int size() {
                return dimLookup.size();
            }

            @Override
            public String get(int index) {
                Object val = dimLookup.getValueFromSortedId(index);
                String strVal = val != null ? val.toString() : null;
                return strVal;
            }

            @Override
            public int indexOf(String value) {
                int id = dimDim.getId(value);
                return id < 0 ? -1 : dimLookup.getSortedIdFromUnsortedId(id);
            }

            @Override
            public Iterator<String> iterator() {
                return IndexedIterable.create(this).iterator();
            }
        };
    }

    @Override
    public Iterable<Rowboat> getRows() {
        return new Iterable<Rowboat>(){

            @Override
            public Iterator<Rowboat> iterator() {
                final List<IncrementalIndex.DimensionDesc> dimensions = IncrementalIndexAdapter.this.index.getDimensions();
                final IncrementalIndex.SortedDimLookup[] sortedDimLookups = new IncrementalIndex.SortedDimLookup[dimensions.size()];
                for (IncrementalIndex.DimensionDesc dimension : dimensions) {
                    sortedDimLookups[dimension.getIndex()] = ((DimensionIndexer)IncrementalIndexAdapter.this.indexers.get(dimension.getName())).getDimLookup();
                }
                return Iterators.transform(IncrementalIndexAdapter.this.index.getFacts().entrySet().iterator(), (Function)new Function<Map.Entry<IncrementalIndex.TimeAndDims, Integer>, Rowboat>(){
                    int count = 0;

                    public Rowboat apply(Map.Entry<IncrementalIndex.TimeAndDims, Integer> input) {
                        IncrementalIndex.TimeAndDims timeAndDims = input.getKey();
                        int[][] dimValues = timeAndDims.getDims();
                        int rowOffset = input.getValue();
                        int[][] dims = new int[dimValues.length][];
                        for (IncrementalIndex.DimensionDesc dimension : dimensions) {
                            int dimIndex = dimension.getIndex();
                            if (dimIndex >= dimValues.length || dimValues[dimIndex] == null) continue;
                            dims[dimIndex] = new int[dimValues[dimIndex].length];
                            if (dimIndex >= dims.length || dims[dimIndex] == null) continue;
                            for (int i = 0; i < dimValues[dimIndex].length; ++i) {
                                dims[dimIndex][i] = sortedDimLookups[dimIndex].getSortedIdFromUnsortedId(dimValues[dimIndex][i]);
                            }
                        }
                        Object[] metrics = new Object[IncrementalIndexAdapter.this.index.getMetricAggs().length];
                        for (int i = 0; i < metrics.length; ++i) {
                            metrics[i] = IncrementalIndexAdapter.this.index.getMetricObjectValue(rowOffset, i);
                        }
                        return new Rowboat(timeAndDims.getTimestamp(), dims, metrics, this.count++);
                    }
                });
            }
        };
    }

    @Override
    public IndexedInts getBitmapIndex(String dimension, int index) {
        DimensionIndexer accessor = this.indexers.get(dimension);
        if (accessor == null) {
            return EmptyIndexedInts.EMPTY_INDEXED_INTS;
        }
        IncrementalIndex.SortedDimLookup dimLookup = accessor.getDimLookup();
        int id = dimLookup.getUnsortedIdFromSortedId(index);
        if (id < 0 || id >= dimLookup.size()) {
            return EmptyIndexedInts.EMPTY_INDEXED_INTS;
        }
        MutableBitmap bitmapIndex = accessor.invertedIndexes[id];
        if (bitmapIndex == null) {
            return EmptyIndexedInts.EMPTY_INDEXED_INTS;
        }
        return new BitmapIndexedInts(bitmapIndex);
    }

    @Override
    public String getMetricType(String metric) {
        return this.index.getMetricType(metric);
    }

    @Override
    public ColumnCapabilities getCapabilities(String column) {
        return this.index.getCapabilities(column);
    }

    private boolean hasNullValue(IncrementalIndex.DimDim dimDim, int[] dimIndices) {
        if (dimIndices == null || dimIndices.length == 0) {
            return true;
        }
        for (int dimIndex : dimIndices) {
            Object val = dimDim.getValue(dimIndex);
            if (val == null) {
                return true;
            }
            if (!(val instanceof String) || ((String)val).length() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    static class BitmapIndexedInts
    implements IndexedInts {
        private final MutableBitmap bitmapIndex;

        BitmapIndexedInts(MutableBitmap bitmapIndex) {
            this.bitmapIndex = bitmapIndex;
        }

        @Override
        public int size() {
            return this.bitmapIndex.size();
        }

        @Override
        public int get(int index) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                final IntIterator baseIter;
                {
                    this.baseIter = BitmapIndexedInts.this.bitmapIndex.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.baseIter.hasNext();
                }

                @Override
                public Integer next() {
                    return this.baseIter.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public void fill(int index, int[] toFill) {
            throw new UnsupportedOperationException("fill not supported");
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class DimensionIndexer {
        private final IncrementalIndex.DimensionDesc dimensionDesc;
        private final MutableBitmap[] invertedIndexes;
        private IncrementalIndex.SortedDimLookup dimLookup;

        public DimensionIndexer(IncrementalIndex.DimensionDesc dimensionDesc) {
            this.dimensionDesc = dimensionDesc;
            this.invertedIndexes = new MutableBitmap[dimensionDesc.getValues().size() + 1];
        }

        private IncrementalIndex.DimDim getDimValues() {
            return this.dimensionDesc.getValues();
        }

        private IncrementalIndex.SortedDimLookup getDimLookup() {
            if (this.dimLookup == null) {
                IncrementalIndex.DimDim dimDim = this.dimensionDesc.getValues();
                if (IncrementalIndexAdapter.this.hasNullValueDimensions.contains(this.dimensionDesc.getName()) && !dimDim.contains(null)) {
                    dimDim.add(null);
                }
                this.dimLookup = dimDim.sort();
            }
            return this.dimLookup;
        }
    }
}

