/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.segment.FloatColumnSerializer;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.CompressedFloatsIndexedSupplier;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.FloatGenericColumnSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class FloatGenericColumnPartSerde
implements ColumnPartSerde {
    private final ByteOrder byteOrder;
    private ColumnPartSerde.Serializer serializer;

    @JsonCreator
    public static FloatGenericColumnPartSerde createDeserializer(@JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new FloatGenericColumnPartSerde(byteOrder, null);
    }

    private FloatGenericColumnPartSerde(ByteOrder byteOrder, ColumnPartSerde.Serializer serializer) {
        this.byteOrder = byteOrder;
        this.serializer = serializer;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    public static LegacySerializerBuilder legacySerializerBuilder() {
        return new LegacySerializerBuilder();
    }

    @Override
    public ColumnPartSerde.Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                CompressedFloatsIndexedSupplier column = CompressedFloatsIndexedSupplier.fromByteBuffer(buffer, FloatGenericColumnPartSerde.this.byteOrder);
                builder.setType(ValueType.FLOAT).setHasMultipleValues(false).setGenericColumn(new FloatGenericColumnSupplier(column, FloatGenericColumnPartSerde.this.byteOrder));
            }
        };
    }

    public static class LegacySerializerBuilder {
        private ByteOrder byteOrder = null;
        private CompressedFloatsIndexedSupplier delegate = null;

        public LegacySerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public LegacySerializerBuilder withDelegate(CompressedFloatsIndexedSupplier delegate) {
            this.delegate = delegate;
            return this;
        }

        public FloatGenericColumnPartSerde build() {
            return new FloatGenericColumnPartSerde(this.byteOrder, new ColumnPartSerde.Serializer(){

                @Override
                public long numBytes() {
                    return LegacySerializerBuilder.this.delegate.getSerializedSize();
                }

                @Override
                public void write(WritableByteChannel channel) throws IOException {
                    LegacySerializerBuilder.this.delegate.writeToChannel(channel);
                }
            });
        }
    }

    public static class SerializerBuilder {
        private ByteOrder byteOrder = null;
        private FloatColumnSerializer delegate = null;

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withDelegate(FloatColumnSerializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public FloatGenericColumnPartSerde build() {
            return new FloatGenericColumnPartSerde(this.byteOrder, new ColumnPartSerde.Serializer(){

                @Override
                public long numBytes() {
                    return SerializerBuilder.this.delegate.getSerializedSize();
                }

                @Override
                public void write(WritableByteChannel channel) throws IOException {
                    SerializerBuilder.this.delegate.writeToChannel(channel);
                }
            });
        }
    }
}

