/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import io.druid.java.util.common.io.Closer;
import io.druid.java.util.common.parsers.CloseableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class CloseableIterators {
    public static <T> CloseableIterator<T> concat(List<? extends CloseableIterator<? extends T>> iterators) {
        Closer closer = Closer.create();
        iterators.forEach(closer::register);
        Iterator innerIterator = Iterators.concat(iterators.iterator());
        return CloseableIterators.wrap(innerIterator, closer);
    }

    public static <T> CloseableIterator<T> mergeSorted(List<? extends CloseableIterator<? extends T>> iterators, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Closer closer = Closer.create();
        iterators.forEach(closer::register);
        UnmodifiableIterator innerIterator = Iterators.mergeSorted(iterators, comparator);
        return CloseableIterators.wrap(innerIterator, closer);
    }

    public static <T> CloseableIterator<T> wrap(final Iterator<T> innerIterator, final @Nullable Closeable closeable) {
        return new CloseableIterator<T>(){
            private boolean closed;

            @Override
            public boolean hasNext() {
                return innerIterator.hasNext();
            }

            @Override
            public T next() {
                return innerIterator.next();
            }

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    if (closeable != null) {
                        closeable.close();
                    }
                    this.closed = true;
                }
            }
        };
    }

    public static <T> CloseableIterator<T> withEmptyBaggage(Iterator<T> innerIterator) {
        return CloseableIterators.wrap(innerIterator, null);
    }

    private CloseableIterators() {
    }
}

