/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import io.druid.java.util.common.MappedByteBufferHandler;
import io.druid.java.util.common.StreamUtils;
import io.druid.java.util.common.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.MappedByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;

public class FileUtils {
    public static final Predicate<Throwable> IS_EXCEPTION = new Predicate<Throwable>(){

        public boolean apply(Throwable input) {
            return input instanceof Exception;
        }
    };

    public static FileCopyResult retryCopy(ByteSource byteSource, File outFile, Predicate<Throwable> shouldRetry, int maxAttempts) {
        try {
            StreamUtils.retryCopy(byteSource, com.google.common.io.Files.asByteSink((File)outFile, (FileWriteMode[])new FileWriteMode[0]), shouldRetry, maxAttempts);
            return new FileCopyResult(outFile);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static MappedByteBufferHandler map(File file) throws IOException {
        MappedByteBuffer mappedByteBuffer = com.google.common.io.Files.map((File)file);
        return new MappedByteBufferHandler(mappedByteBuffer);
    }

    public static void writeAtomically(File file, OutputStreamConsumer f) throws IOException {
        FileUtils.writeAtomically(file, file.getParentFile(), f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAtomically(File file, File tmpDir, OutputStreamConsumer f) throws IOException {
        File tmpFile = new File(tmpDir, StringUtils.format(".%s.%s", file.getName(), UUID.randomUUID()));
        try {
            try (FileOutputStream out = new FileOutputStream(tmpFile);){
                f.accept(FileUtils.uncloseable(out));
                out.getChannel().force(true);
            }
            Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            tmpFile.delete();
        }
    }

    private static OutputStream uncloseable(OutputStream out) throws IOException {
        return new FilterOutputStream(out){

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static interface OutputStreamConsumer {
        public void accept(OutputStream var1) throws IOException;
    }

    public static class FileCopyResult {
        private final Collection<File> files = Lists.newArrayList();
        private long size = 0L;

        public Collection<File> getFiles() {
            return ImmutableList.copyOf(this.files);
        }

        public long size() {
            return this.size;
        }

        public FileCopyResult(File ... files) {
            this((Collection<File>)(files == null ? ImmutableList.of() : Arrays.asList(files)));
        }

        public FileCopyResult(Collection<File> files) {
            this.addSizedFiles(files);
        }

        protected void addSizedFiles(Collection<File> files) {
            if (files == null || files.isEmpty()) {
                return;
            }
            long size = 0L;
            for (File file : files) {
                size += file.length();
            }
            this.files.addAll(files);
            this.size += size;
        }

        public void addFiles(Collection<File> files) {
            this.addSizedFiles(files);
        }

        public void addFile(File file) {
            this.addFiles((Collection<File>)ImmutableList.of((Object)file));
        }
    }
}

