/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Charsets;
import com.google.common.collect.FluentIterable;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.parsers.ObjectFlatteners;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.exception.JsonQueryException;

public class JSONFlattenerMaker
implements ObjectFlatteners.FlattenerMaker<JsonNode> {
    private static final Configuration JSONPATH_CONFIGURATION = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(EnumSet.of(Option.SUPPRESS_EXCEPTIONS)).build();
    private final CharsetEncoder enc = Charsets.UTF_8.newEncoder();

    @Override
    public Iterable<String> discoverRootFields(JsonNode obj) {
        return FluentIterable.from(() -> obj.fields()).filter(entry -> {
            JsonNode val = (JsonNode)entry.getValue();
            return !val.isObject() && !val.isNull() && (!val.isArray() || this.isFlatList(val));
        }).transform(Map.Entry::getKey);
    }

    @Override
    public Object getRootField(JsonNode obj, String key) {
        return this.valueConversionFunction(obj.get(key));
    }

    @Override
    public Function<JsonNode, Object> makeJsonPathExtractor(String expr) {
        JsonPath jsonPath = JsonPath.compile((String)expr, (Predicate[])new Predicate[0]);
        return node -> this.valueConversionFunction((JsonNode)jsonPath.read(node, JSONPATH_CONFIGURATION));
    }

    @Override
    public Function<JsonNode, Object> makeJsonQueryExtractor(String expr) {
        try {
            JsonQuery jsonQuery = JsonQuery.compile((String)expr);
            return jsonNode -> {
                try {
                    return this.valueConversionFunction((JsonNode)jsonQuery.apply(jsonNode).get(0));
                }
                catch (JsonQueryException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (JsonQueryException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private Object valueConversionFunction(JsonNode val) {
        if (val == null || val.isNull()) {
            return null;
        }
        if (val.isInt() || val.isLong()) {
            return val.asLong();
        }
        if (val.isNumber()) {
            return val.asDouble();
        }
        if (val.isTextual()) {
            return this.charsetFix(val.asText());
        }
        if (val.isArray()) {
            ArrayList<Object> newList = new ArrayList<Object>();
            for (JsonNode entry : val) {
                newList.add(this.valueConversionFunction(entry));
            }
            return newList;
        }
        if (val.isObject()) {
            LinkedHashMap newMap = new LinkedHashMap();
            Iterator it = val.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                newMap.put(entry.getKey(), this.valueConversionFunction((JsonNode)entry.getValue()));
            }
            return newMap;
        }
        return val;
    }

    @Nullable
    private String charsetFix(String s) {
        if (s != null && !this.enc.canEncode(s)) {
            return StringUtils.fromUtf8(StringUtils.toUtf8(s));
        }
        return s;
    }

    private boolean isFlatList(JsonNode list) {
        for (JsonNode obj : list) {
            if (!obj.isObject() && !obj.isArray()) continue;
            return false;
        }
        return true;
    }
}

