/*
 * Decompiled with CFR 0.152.
 */
package io.dubbo.springboot;

import com.alibaba.dubbo.config.spring.AnnotationBean;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class DubboConfigurationApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment env = applicationContext.getEnvironment();
        String scan = env.getProperty("spring.dubbo.scan");
        if (scan != null) {
            AnnotationBean scanner = (AnnotationBean)BeanUtils.instantiate(AnnotationBean.class);
            scanner.setPackage(scan);
            scanner.setApplicationContext((ApplicationContext)applicationContext);
            applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)scanner);
            applicationContext.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)scanner);
            applicationContext.getBeanFactory().registerSingleton("annotationBean", (Object)scanner);
        }
    }
}

