/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.math;

import io.github.alexzhirkevich.compottie.internal.AnimationState;
import io.github.alexzhirkevich.compottie.internal.animation.RawProperty;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.EvaluationContext;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.Expression;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.math.OpAddKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.math.OpIncrementKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpAssign;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpAssignByIndex;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpGetVariable;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpIndex;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a,\u0010\u000e\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\"\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"isAssignable", "", "Lio/github/alexzhirkevich/compottie/internal/animation/expressions/Expression;", "nameForAssignment", "", "getNameForAssignment", "(Lio/github/alexzhirkevich/compottie/internal/animation/expressions/Expression;)Ljava/lang/String;", "OpIncrement", "variable", "OpDecrement", "increment", "", "v", "decrement", "OpIncDec", "op", "Lkotlin/Function1;", "name", "compottie_release"})
public final class OpIncrementKt {
    public static final boolean isAssignable(@NotNull Expression $this$isAssignable) {
        Intrinsics.checkNotNullParameter((Object)$this$isAssignable, (String)"<this>");
        return $this$isAssignable instanceof OpGetVariable && ((OpGetVariable)$this$isAssignable).getAssignmentType() == null || $this$isAssignable instanceof OpIndex && ((OpIndex)$this$isAssignable).getVariable() instanceof OpGetVariable;
    }

    @NotNull
    public static final String getNameForAssignment(@NotNull Expression $this$nameForAssignment) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$nameForAssignment, (String)"<this>");
        if ($this$nameForAssignment instanceof OpGetVariable && ((OpGetVariable)$this$nameForAssignment).getAssignmentType() == null) {
            string = ((OpGetVariable)$this$nameForAssignment).getName();
        } else if ($this$nameForAssignment instanceof OpIndex && ((OpIndex)$this$nameForAssignment).getVariable() instanceof OpGetVariable) {
            string = ((OpGetVariable)((OpIndex)$this$nameForAssignment).getVariable()).getName();
        } else {
            throw new IllegalStateException("Expression is not left assignable".toString());
        }
        return string;
    }

    @NotNull
    public static final Expression OpIncrement(@NotNull Expression variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return OpIncrementKt.OpIncDec(variable, (Function1<Object, ? extends Object>)((Function1)OpIncrement.1.INSTANCE), "increment");
    }

    @NotNull
    public static final Expression OpDecrement(@NotNull Expression variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return OpIncrementKt.OpIncDec(variable, (Function1<Object, ? extends Object>)((Function1)OpDecrement.1.INSTANCE), "decrement");
    }

    private static final Object increment(Object v) {
        Number number;
        Object v2 = OpAddKt.validateJsNumber(v);
        if (v2 instanceof Long) {
            number = ((Number)v2).longValue() + 1L;
        } else if (v2 instanceof Double) {
            number = ((Number)v2).doubleValue() + 1.0;
        } else if (v2 instanceof Number) {
            number = ((Number)v2).doubleValue() + 1.0;
        } else {
            throw new IllegalStateException(("can't increment " + v2).toString());
        }
        return number;
    }

    private static final Object decrement(Object v) {
        Number number;
        Object v2 = OpAddKt.validateJsNumber(v);
        if (v2 instanceof Long) {
            number = ((Number)v2).longValue() - 1L;
        } else if (v2 instanceof Double) {
            number = ((Number)v2).doubleValue() - 1.0;
        } else if (v2 instanceof Number) {
            number = ((Number)v2).doubleValue() - 1.0;
        } else {
            throw new IllegalStateException(("can't decrement " + v2).toString());
        }
        return number;
    }

    private static final Expression OpIncDec(Expression variable, Function1<Object, ? extends Object> op, String name) {
        Expression expression;
        if (variable instanceof OpGetVariable && ((OpGetVariable)variable).getAssignmentType() == null) {
            expression = new OpAssign(null, ((OpGetVariable)variable).getName(), (arg_0, arg_1, arg_2) -> OpIncrementKt.OpIncDec$lambda$0(op, variable, arg_0, arg_1, arg_2), null, 1, null);
        } else if (variable instanceof OpIndex && ((OpIndex)variable).getVariable() instanceof OpGetVariable) {
            String string = ((OpGetVariable)((OpIndex)variable).getVariable()).getName();
            Expression expression2 = ((OpIndex)variable).getIndex();
            Expression expression3 = (arg_0, arg_1, arg_2) -> OpIncrementKt.OpIncDec$lambda$1(op, variable, arg_0, arg_1, arg_2);
            expression = new OpAssignByIndex(string, null, expression2, expression3, null);
        } else {
            throw new IllegalStateException(("Can't " + name + " " + variable).toString());
        }
        return expression;
    }

    private static final Object OpIncDec$lambda$0(Function1 $op, Expression $variable, RawProperty property, EvaluationContext context, AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return $op.invoke(((OpGetVariable)$variable).invoke(property, context, state));
    }

    private static final Object OpIncDec$lambda$1(Function1 $op, Expression $variable, RawProperty property, EvaluationContext context, AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return $op.invoke(((OpIndex)$variable).invoke(property, context, state));
    }

    public static final /* synthetic */ Object access$increment(Object v) {
        return OpIncrementKt.increment(v);
    }

    public static final /* synthetic */ Object access$decrement(Object v) {
        return OpIncrementKt.decrement(v);
    }
}

