/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.effects;

import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.Paint;
import io.github.alexzhirkevich.compottie.internal.AnimationState;
import io.github.alexzhirkevich.compottie.internal.animation.AnimatedColor;
import io.github.alexzhirkevich.compottie.internal.animation.AnimatedNumber;
import io.github.alexzhirkevich.compottie.internal.animation.AnimatedNumberKt;
import io.github.alexzhirkevich.compottie.internal.animation.DynamicProperty;
import io.github.alexzhirkevich.compottie.internal.effects.BlurEffect;
import io.github.alexzhirkevich.compottie.internal.effects.DropShadowEffect;
import io.github.alexzhirkevich.compottie.internal.effects.FillEffect;
import io.github.alexzhirkevich.compottie.internal.effects.LayerEffectsState;
import io.github.alexzhirkevich.compottie.internal.effects.TintEffect;
import io.github.alexzhirkevich.compottie.internal.platform.PlatformShader_androidKt;
import io.github.alexzhirkevich.compottie.internal.platform.effects.PlatformDropShadowEffect;
import io.github.alexzhirkevich.compottie.internal.platform.effects.PlatformDropShadowEffect_androidKt;
import io.github.alexzhirkevich.compottie.internal.utils.MiscUtilKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a8\u0006\u000f"}, d2={"applyBlurEffect", "", "Landroidx/compose/ui/graphics/Paint;", "effect", "Lio/github/alexzhirkevich/compottie/internal/effects/BlurEffect;", "animationState", "Lio/github/alexzhirkevich/compottie/internal/AnimationState;", "effectState", "Lio/github/alexzhirkevich/compottie/internal/effects/LayerEffectsState;", "applyFillEffect", "Lio/github/alexzhirkevich/compottie/internal/effects/FillEffect;", "applyTintEffect", "Lio/github/alexzhirkevich/compottie/internal/effects/TintEffect;", "applyDropShadowEffect", "Lio/github/alexzhirkevich/compottie/internal/effects/DropShadowEffect;", "compottie_release"})
@SourceDebugExtension(value={"SMAP\nLayerEffectsApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerEffectsApplier.kt\nio/github/alexzhirkevich/compottie/internal/effects/LayerEffectsApplierKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class LayerEffectsApplierKt {
    private static final void applyBlurEffect(Paint $this$applyBlurEffect, BlurEffect effect, AnimationState animationState, LayerEffectsState effectState) {
        Object object;
        block5: {
            block4: {
                object = effect.getRadius();
                if (object == null) break block4;
                Float f = Float.valueOf(((Number)((DynamicProperty)object).interpolated(animationState)).floatValue());
                float it = ((Number)f).floatValue();
                boolean bl = false;
                object = it > 0.0f ? f : null;
                if (object != null) break block5;
            }
            return;
        }
        float radius = ((Float)object).floatValue();
        if ($this$applyBlurEffect != effectState.getLastPaint() || !Intrinsics.areEqual((float)radius, (Float)effectState.getBlurRadius())) {
            PlatformShader_androidKt.setBlurMaskFilter$default($this$applyBlurEffect, radius, false, 2, null);
            effectState.setBlurRadius(Float.valueOf(radius));
        }
    }

    private static final void applyFillEffect(Paint $this$applyFillEffect, FillEffect effect, AnimationState animationState, LayerEffectsState effectState) {
        Color color;
        Color color2;
        AnimatedColor animatedColor = effect.getColor();
        if (animatedColor != null) {
            long it = ((Color)animatedColor.interpolated(animationState)).unbox-impl();
            boolean bl = false;
            AnimatedNumber animatedNumber = effect.getOpacity();
            color2 = Color.box-impl((long)Color.copy-wmQWz5c$default((long)it, (float)(Color.getAlpha-impl((long)it) * (animatedNumber != null ? RangesKt.coerceIn((float)((Number)animatedNumber.interpolated(animationState)).floatValue(), (float)0.0f, (float)1.0f) : 1.0f)), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null));
        } else {
            color2 = color = null;
        }
        if ($this$applyFillEffect != effectState.getLastPaint() || !Intrinsics.areEqual((Object)effectState.getLastFillColor-QN2ZGVo(), color)) {
            ColorFilter colorFilter;
            Paint paint = $this$applyFillEffect;
            Color color3 = color;
            if (color3 != null) {
                long l = color3.unbox-impl();
                Paint paint2 = paint;
                boolean bl = false;
                colorFilter = ColorFilter.Companion.tint-xETnrds$default((ColorFilter.Companion)ColorFilter.Companion, (long)color.unbox-impl(), (int)0, (int)2, null);
                paint = paint2;
            } else {
                colorFilter = null;
            }
            paint.setColorFilter(colorFilter);
            effectState.setLastFillFilter($this$applyFillEffect.getColorFilter());
            effectState.setLastFillColor-Y2TPw74(color);
        } else {
            $this$applyFillEffect.setColorFilter(effectState.getLastFillFilter());
        }
    }

    private static final void applyTintEffect(Paint $this$applyTintEffect, TintEffect effect, AnimationState animationState, LayerEffectsState effectState) {
        int hash;
        Color white;
        Color color;
        long l;
        AnimatedNumber animatedNumber = effect.getIntensity();
        float intensity = animatedNumber != null ? RangesKt.coerceIn((float)AnimatedNumberKt.interpolatedNorm(animatedNumber, animationState), (float)0.0f, (float)1.0f) : 1.0f;
        AnimatedColor animatedColor = effect.getBlack();
        if (animatedColor != null) {
            long it = ((Color)animatedColor.interpolated(animationState)).unbox-impl();
            boolean bl = false;
            l = Color.copy-wmQWz5c$default((long)it, (float)(Color.getAlpha-impl((long)it) * intensity), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null);
        } else {
            l = Color.Companion.getBlack-0d7_KjU();
        }
        long black = l;
        AnimatedColor animatedColor2 = effect.getWhite();
        if (animatedColor2 != null) {
            long it = ((Color)animatedColor2.interpolated(animationState)).unbox-impl();
            boolean bl = false;
            color = Color.box-impl((long)Color.copy-wmQWz5c$default((long)it, (float)(Color.getAlpha-impl((long)it) * intensity), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null));
        } else {
            color = white = null;
        }
        if (!(Color.getRed-impl((long)black) == 0.0f && Color.getGreen-impl((long)black) == 0.0f && Color.getBlue-impl((long)black) == 0.0f)) {
            return;
        }
        Color color2 = white;
        int n = hash = color2 != null ? color2.hashCode() : 0;
        if ($this$applyTintEffect == effectState.getLastPaint()) {
            Integer n2 = effectState.getTintHash();
            if (n2 != null && hash == n2 && effectState.getTintColorFiter() != null) {
                $this$applyTintEffect.setColorFilter(effectState.getTintColorFiter());
                return;
            }
        }
        $this$applyTintEffect.setColorFilter(white != null ? ColorFilter.Companion.tint-xETnrds(white.unbox-impl(), BlendMode.Companion.getModulate-0nO6VwU()) : null);
        effectState.setTintHash(hash);
        effectState.setTintColorFiter($this$applyTintEffect.getColorFilter());
    }

    public static final void applyDropShadowEffect(@NotNull Paint $this$applyDropShadowEffect, @NotNull DropShadowEffect effect, @NotNull AnimationState animationState, @NotNull LayerEffectsState effectState) {
        block3: {
            int hash;
            float radius;
            long color;
            float y;
            float x;
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$applyDropShadowEffect, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
                Intrinsics.checkNotNullParameter((Object)animationState, (String)"animationState");
                Intrinsics.checkNotNullParameter((Object)effectState, (String)"effectState");
                AnimatedNumber animatedNumber = effect.getAngle();
                float directionRad = MiscUtilKt.degreeToRadians(animatedNumber != null ? ((Number)animatedNumber.interpolated(animationState)).floatValue() : 0.0f);
                AnimatedNumber animatedNumber2 = effect.getDistance();
                float distance = animatedNumber2 != null ? ((Number)animatedNumber2.interpolated(animationState)).floatValue() : 0.0f;
                x = (float)Math.sin(directionRad) * distance;
                y = (float)Math.cos((double)directionRad + Math.PI) * distance;
                AnimatedColor animatedColor = effect.getColor();
                long baseColor = animatedColor != null ? ((Color)animatedColor.interpolated(animationState)).unbox-impl() : Color.Companion.getBlack-0d7_KjU();
                AnimatedNumber animatedNumber3 = effect.getOpacity();
                float opacity = animatedNumber3 != null ? RangesKt.coerceIn((float)(((Number)animatedNumber3.interpolated(animationState)).floatValue() / (float)100), (float)0.0f, (float)1.0f) : 1.0f;
                color = Color.copy-wmQWz5c((long)baseColor, (float)(opacity * Color.getAlpha-impl((long)baseColor)), (float)Color.getRed-impl((long)baseColor), (float)Color.getGreen-impl((long)baseColor), (float)Color.getBlue-impl((long)baseColor));
                AnimatedNumber animatedNumber4 = effect.getBlur();
                radius = animatedNumber4 != null ? ((Number)animatedNumber4.interpolated(animationState)).floatValue() : 0.0f;
                Object[] objectArray = new Object[]{Float.valueOf(x), Float.valueOf(y), Color.box-impl((long)color), Float.valueOf(radius)};
                hash = Arrays.hashCode(objectArray);
                if (effectState.getLastPaint() != $this$applyDropShadowEffect) break block2;
                Integer n = effectState.getDropShadowHash();
                if (n != null && hash == n && effectState.getDropShadowEffect() != null) break block3;
            }
            effectState.setDropShadowEffect(PlatformDropShadowEffect_androidKt.makeNativeDropShadowEffect-g2O1Hgs(radius, x, y, color));
            effectState.setDropShadowHash(hash);
        }
        PlatformDropShadowEffect platformDropShadowEffect = effectState.getDropShadowEffect();
        Intrinsics.checkNotNull((Object)platformDropShadowEffect);
        PlatformDropShadowEffect_androidKt.applyNativeDropShadowEffect($this$applyDropShadowEffect, platformDropShadowEffect);
    }

    public static final /* synthetic */ void access$applyBlurEffect(Paint $receiver, BlurEffect effect, AnimationState animationState, LayerEffectsState effectState) {
        LayerEffectsApplierKt.applyBlurEffect($receiver, effect, animationState, effectState);
    }

    public static final /* synthetic */ void access$applyFillEffect(Paint $receiver, FillEffect effect, AnimationState animationState, LayerEffectsState effectState) {
        LayerEffectsApplierKt.applyFillEffect($receiver, effect, animationState, effectState);
    }

    public static final /* synthetic */ void access$applyTintEffect(Paint $receiver, TintEffect effect, AnimationState animationState, LayerEffectsState effectState) {
        LayerEffectsApplierKt.applyTintEffect($receiver, effect, animationState, effectState);
    }
}

