/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.utils;

import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.PathEffect;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0011\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0003\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a2\u0006\u0002\u0010\u0006\u001a\u0017\u0010\u0007\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a2\u0006\u0002\u0010\u0006\u001a\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0000\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002\u001a \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0000\u001a \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0000\u001a \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0000\u001a(\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u001a \u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\u0006\b\u0000\u0010\u001e\u0018\u0001*\u0006\u0012\u0002\b\u00030\u0004H\u0080\b\u00a2\u0006\u0002\u0010\u001f\u001a(\u0010 \u001a\u0004\u0018\u0001H\u001e\"\u0006\b\u0000\u0010\u001e\u0018\u0001*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010!\u001a\u00020\u0011H\u0080\b\u00a2\u0006\u0002\u0010\"\u001a\u0014\u0010#\u001a\u00020$*\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"toOffset", "Landroidx/compose/ui/geometry/Offset;", "", "([F)J", "", "", "(Ljava/util/List;)J", "toSize", "Landroidx/compose/ui/geometry/Size;", "PiDiv180", "", "PiDiv180Float", "degreeToRadians", "degree", "radiansToDegree", "radians", "floorMod", "", "x", "y", "floorDiv", "hslToRed", "h", "s", "l", "hslToGreen", "hslToBlue", "hslToRgbComponent", "n", "firstInstanceOf", "R", "(Ljava/util/List;)Ljava/lang/Object;", "getAs", "index", "(Ljava/util/List;I)Ljava/lang/Object;", "appendPathEffect", "", "Landroidx/compose/ui/graphics/Paint;", "effect", "Landroidx/compose/ui/graphics/PathEffect;", "compottie_release"})
@SourceDebugExtension(value={"SMAP\nMiscUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiscUtil.kt\nio/github/alexzhirkevich/compottie/internal/utils/MiscUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n295#2,2:79\n*S KotlinDebug\n*F\n+ 1 MiscUtil.kt\nio/github/alexzhirkevich/compottie/internal/utils/MiscUtilKt\n*L\n65#1:79,2\n*E\n"})
public final class MiscUtilKt {
    private static final double PiDiv180 = Math.PI / 180;
    private static final float PiDiv180Float = (float)PiDiv180;

    public static final long toOffset(@NotNull float[] $this$toOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$toOffset, (String)"<this>");
        return OffsetKt.Offset((float)$this$toOffset[0], (float)$this$toOffset[1]);
    }

    public static final long toOffset(@NotNull List<Float> $this$toOffset) {
        Intrinsics.checkNotNullParameter($this$toOffset, (String)"<this>");
        return OffsetKt.Offset((float)((Number)$this$toOffset.get(0)).floatValue(), (float)((Number)$this$toOffset.get(1)).floatValue());
    }

    public static final long toSize(@NotNull List<Float> $this$toSize) {
        Intrinsics.checkNotNullParameter($this$toSize, (String)"<this>");
        return SizeKt.Size((float)((Number)$this$toSize.get(0)).floatValue(), (float)((Number)$this$toSize.get(1)).floatValue());
    }

    public static final float degreeToRadians(float degree) {
        return degree * PiDiv180Float;
    }

    public static final double degreeToRadians(double degree) {
        return degree * PiDiv180;
    }

    public static final float radiansToDegree(float radians) {
        return radians / PiDiv180Float;
    }

    public static final double radiansToDegree(double radians) {
        return radians / PiDiv180;
    }

    public static final int floorMod(float x, float y) {
        return MiscUtilKt.floorMod((int)x, (int)y);
    }

    public static final int floorMod(int x, int y) {
        return x - y * MiscUtilKt.floorDiv(x, y);
    }

    private static final int floorDiv(int x, int y) {
        int r = x / y;
        boolean sameSign = (x ^ y) >= 0;
        int mod = x % y;
        if (!sameSign && mod != 0) {
            --r;
        }
        return r;
    }

    public static final float hslToRed(float h, float s, float l) {
        return MiscUtilKt.hslToRgbComponent(0, h, s, l);
    }

    public static final float hslToGreen(float h, float s, float l) {
        return MiscUtilKt.hslToRgbComponent(8, h, s, l);
    }

    public static final float hslToBlue(float h, float s, float l) {
        return MiscUtilKt.hslToRgbComponent(4, h, s, l);
    }

    private static final float hslToRgbComponent(int n, float h, float s, float l) {
        float k = ((float)n + h / 30.0f) % 12.0f;
        float a = s * Math.min(l, 1.0f - l);
        return l - a * Math.max(-1.0f, Math.min(k - (float)3, Math.min((float)9 - k, 1.0f)));
    }

    public static final /* synthetic */ <R> R firstInstanceOf(List<?> $this$firstInstanceOf) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$firstInstanceOf, (String)"<this>");
            boolean $i$f$firstInstanceOf = false;
            Iterable $this$firstOrNull$iv = $this$firstInstanceOf;
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Intrinsics.reifiedOperationMarker((int)3, (String)"R");
                if (!(it instanceof Object)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.reifiedOperationMarker((int)2, (String)"R");
        return (R)((Object)v0);
    }

    public static final /* synthetic */ <R> R getAs(List<?> $this$getAs, int index) {
        Intrinsics.checkNotNullParameter($this$getAs, (String)"<this>");
        boolean $i$f$getAs = false;
        Object object = CollectionsKt.getOrNull($this$getAs, (int)index);
        Intrinsics.reifiedOperationMarker((int)2, (String)"R");
        return (R)object;
    }

    public static final void appendPathEffect(@NotNull Paint $this$appendPathEffect, @NotNull PathEffect effect) {
        Intrinsics.checkNotNullParameter((Object)$this$appendPathEffect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        if ($this$appendPathEffect.getPathEffect() == null) {
            $this$appendPathEffect.setPathEffect(effect);
        } else {
            PathEffect pathEffect = $this$appendPathEffect.getPathEffect();
            Intrinsics.checkNotNull((Object)pathEffect);
            $this$appendPathEffect.setPathEffect(PathEffect.Companion.chainPathEffect(effect, pathEffect));
        }
    }
}

