/*
 * Decompiled with CFR 0.152.
 */
package top.zibin.luban;

import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import top.zibin.luban.InputStreamProvider;

public enum Checker {
    SINGLE;

    private static final String TAG = "Luban";
    private static final String JPG = ".jpg";
    private final byte[] JPEG_SIGNATURE = new byte[]{-1, -40, -1};

    boolean isJPG(InputStream is) {
        return this.isJPG(this.toByteArray(is));
    }

    int getOrientation(InputStream is) {
        return this.getOrientation(this.toByteArray(is));
    }

    private boolean isJPG(byte[] data) {
        if (data == null || data.length < 3) {
            return false;
        }
        byte[] signatureB = new byte[]{data[0], data[1], data[2]};
        return Arrays.equals(this.JPEG_SIGNATURE, signatureB);
    }

    public static boolean isContent(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        return url.startsWith("content://");
    }

    private int getOrientation(byte[] jpeg) {
        if (jpeg == null) {
            return 0;
        }
        int offset = 0;
        int length = 0;
        while (offset + 3 < jpeg.length && (jpeg[offset++] & 0xFF) == 255) {
            int marker = jpeg[offset] & 0xFF;
            if (marker == 255) continue;
            ++offset;
            if (marker == 216 || marker == 1) continue;
            if (marker == 217 || marker == 218) break;
            length = this.pack(jpeg, offset, 2, false);
            if (length < 2 || offset + length > jpeg.length) {
                Log.e((String)TAG, (String)"Invalid length");
                return 0;
            }
            if (marker == 225 && length >= 8 && this.pack(jpeg, offset + 2, 4, false) == 1165519206 && this.pack(jpeg, offset + 6, 2, false) == 0) {
                offset += 8;
                length -= 8;
                break;
            }
            offset += length;
            length = 0;
        }
        if (length > 8) {
            int tag = this.pack(jpeg, offset, 4, false);
            if (tag != 1229531648 && tag != 1296891946) {
                Log.e((String)TAG, (String)"Invalid byte order");
                return 0;
            }
            boolean littleEndian = tag == 1229531648;
            int count = this.pack(jpeg, offset + 4, 4, littleEndian) + 2;
            if (count < 10 || count > length) {
                Log.e((String)TAG, (String)"Invalid offset");
                return 0;
            }
            offset += count;
            length -= count;
            count = this.pack(jpeg, offset - 2, 2, littleEndian);
            while (count-- > 0 && length >= 12) {
                tag = this.pack(jpeg, offset, 2, littleEndian);
                if (tag == 274) {
                    int orientation = this.pack(jpeg, offset + 8, 2, littleEndian);
                    switch (orientation) {
                        case 1: {
                            return 0;
                        }
                        case 3: {
                            return 180;
                        }
                        case 6: {
                            return 90;
                        }
                        case 8: {
                            return 270;
                        }
                    }
                    Log.e((String)TAG, (String)"Unsupported orientation");
                    return 0;
                }
                offset += 12;
                length -= 12;
            }
        }
        Log.e((String)TAG, (String)"Orientation not found");
        return 0;
    }

    String extSuffix(InputStreamProvider input) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)input.open(), null, (BitmapFactory.Options)options);
            return options.outMimeType.replace("image/", ".");
        }
        catch (Exception e) {
            return JPG;
        }
    }

    boolean needCompress(int leastCompressSize, String path) {
        if (leastCompressSize > 0) {
            File source = new File(path);
            return source.exists() && source.length() > (long)leastCompressSize << 10;
        }
        return true;
    }

    private int pack(byte[] bytes, int offset, int length, boolean littleEndian) {
        int step = 1;
        if (littleEndian) {
            offset += length - 1;
            step = -1;
        }
        int value = 0;
        while (length-- > 0) {
            value = value << 8 | bytes[offset] & 0xFF;
            offset += step;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArray(InputStream is) {
        if (is == null) {
            return new byte[0];
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        try {
            int read;
            while ((read = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, read);
            }
        }
        catch (Exception ignored) {
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            try {
                buffer.close();
            }
            catch (IOException iOException) {}
        }
        return buffer.toByteArray();
    }
}

