/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.adapter.web.handler;

import com.dtp.adapter.web.handler.AbstractWebServerTpHandler;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.config.web.TomcatThreadPool;
import com.dtp.common.dto.ThreadPoolStats;
import com.dtp.common.ex.DtpException;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.catalina.Service;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.server.WebServer;

public class TomcatTpHandler
extends AbstractWebServerTpHandler {
    private static final Logger log = LoggerFactory.getLogger(TomcatTpHandler.class);

    @Override
    public Executor doGetTp(WebServer webServer) {
        TomcatWebServer tomcatWebServer = (TomcatWebServer)webServer;
        Service service = tomcatWebServer.getTomcat().getService();
        if (service.findConnectors().length > 0) {
            return service.findConnectors()[0].getProtocolHandler().getExecutor();
        }
        return null;
    }

    @Override
    public ThreadPoolStats getPoolStats() {
        ThreadPoolExecutor executor = this.convertAndGet();
        return ThreadPoolStats.builder().corePoolSize(executor.getCorePoolSize()).maximumPoolSize(executor.getMaximumPoolSize()).queueType(executor.getQueue().getClass().getSimpleName()).queueCapacity(executor.getQueue().size() + executor.getQueue().remainingCapacity()).queueSize(executor.getQueue().size()).queueRemainingCapacity(executor.getQueue().remainingCapacity()).activeCount(executor.getActiveCount()).taskCount(executor.getTaskCount()).completedTaskCount(executor.getCompletedTaskCount()).largestPoolSize(executor.getLargestPoolSize()).poolSize(executor.getPoolSize()).waitTaskCount(executor.getQueue().size()).dtpName("tomcatWebServerTp").build();
    }

    @Override
    public void updateWebServerTp(DtpProperties dtpProperties) {
        TomcatThreadPool tomcatTp = dtpProperties.getTomcatTp();
        if (Objects.isNull(tomcatTp)) {
            return;
        }
        int oldMinSpare = this.convertAndGet().getCorePoolSize();
        int oldMax = this.convertAndGet().getMaximumPoolSize();
        this.convertAndGet().setCorePoolSize(tomcatTp.getMinSpare());
        this.convertAndGet().setMaximumPoolSize(tomcatTp.getMax());
        log.info("DynamicTp tomcatWebServerTp refreshed end, minSpare: [{}], max: [{}]", (Object)String.format("%s => %s", oldMinSpare, tomcatTp.getMinSpare()), (Object)String.format("%s => %s", oldMax, tomcatTp.getMax()));
    }

    private ThreadPoolExecutor convertAndGet() {
        Executor executor = this.getWebServerTp();
        if (Objects.isNull(executor)) {
            log.warn("Tomcat web server threadPool is null.");
            throw new DtpException("Tomcat web server threadPool is null.");
        }
        return (ThreadPoolExecutor)executor;
    }
}

