/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.adapter.web.handler;

import com.dtp.adapter.web.handler.AbstractWebServerTpHandler;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.config.web.UndertowThreadPool;
import com.dtp.common.dto.ThreadPoolStats;
import com.dtp.common.ex.DtpException;
import io.undertow.Undertow;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowWebServer;
import org.springframework.boot.web.server.WebServer;
import org.springframework.util.ReflectionUtils;
import org.xnio.Options;
import org.xnio.XnioWorker;
import org.xnio.management.XnioWorkerMXBean;

public class UndertowTpHandler
extends AbstractWebServerTpHandler {
    private static final Logger log = LoggerFactory.getLogger(UndertowTpHandler.class);

    @Override
    public Executor doGetTp(WebServer webServer) {
        UndertowWebServer undertowWebServer = (UndertowWebServer)webServer;
        Field undertowField = ReflectionUtils.findField(UndertowWebServer.class, (String)"undertow");
        if (Objects.isNull(undertowField)) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)undertowField);
        Undertow undertow = (Undertow)ReflectionUtils.getField((Field)undertowField, (Object)undertowWebServer);
        if (Objects.isNull(undertow)) {
            return null;
        }
        return undertow.getWorker();
    }

    @Override
    public ThreadPoolStats getPoolStats() {
        XnioWorker xnioWorker = this.convertAndGet();
        XnioWorkerMXBean mxBean = xnioWorker.getMXBean();
        return ThreadPoolStats.builder().corePoolSize(mxBean.getCoreWorkerPoolSize()).maximumPoolSize(mxBean.getMaxWorkerPoolSize()).poolSize(mxBean.getWorkerPoolSize()).activeCount(mxBean.getBusyWorkerThreadCount()).queueSize(mxBean.getWorkerQueueSize()).dtpName("undertowWebServerWorkerTp").build();
    }

    @Override
    public void updateWebServerTp(DtpProperties dtpProperties) {
        UndertowThreadPool undertowTp = dtpProperties.getUndertowTp();
        if (Objects.isNull(undertowTp)) {
            return;
        }
        XnioWorker xnioWorker = this.convertAndGet();
        try {
            int oldCoreWorkerThreads = (Integer)xnioWorker.getOption(Options.WORKER_TASK_CORE_THREADS);
            int oldMaxWorkerThreads = (Integer)xnioWorker.getOption(Options.WORKER_TASK_MAX_THREADS);
            int oldWorkerKeepAlive = (Integer)xnioWorker.getOption(Options.WORKER_TASK_KEEPALIVE);
            int keepAlive = undertowTp.getWorkerKeepAlive() * 1000;
            xnioWorker.setOption(Options.WORKER_TASK_CORE_THREADS, (Object)undertowTp.getCoreWorkerThreads());
            xnioWorker.setOption(Options.WORKER_TASK_MAX_THREADS, (Object)undertowTp.getMaxWorkerThreads());
            xnioWorker.setOption(Options.WORKER_TASK_KEEPALIVE, (Object)keepAlive);
            log.info("DynamicTp undertowWebServerTp refreshed end, coreWorkerThreads: [{}], maxWorkerThreads: [{}], workerThreadKeepAlive: [{}]", new Object[]{String.format("%s => %s", oldCoreWorkerThreads, undertowTp.getCoreWorkerThreads()), String.format("%s => %s", oldMaxWorkerThreads, undertowTp.getMaxWorkerThreads()), String.format("%s => %s", oldWorkerKeepAlive, keepAlive)});
        }
        catch (IOException e) {
            log.error("Update undertow web server threadPool failed.", (Throwable)e);
        }
    }

    private XnioWorker convertAndGet() {
        Executor executor = this.getWebServerTp();
        if (Objects.isNull(executor)) {
            log.warn("Undertow web server threadPool is null.");
            throw new DtpException("Undertow web server threadPool is null.");
        }
        return (XnioWorker)executor;
    }
}

