/*
 * Decompiled with CFR 0.152.
 */
package com.sayalala.wework.wehook;

import com.sayalala.wework.wehook.config.MessagesenderProperties;
import com.sayalala.wework.wehook.service.MessageService;
import com.sayalala.wework.wehook.service.MessageServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;

@Configuration
@AutoConfigureOrder(value=-2147483648)
public class MessageSenderAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MessageSenderAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public MessagesenderProperties getProperties() {
        return new MessagesenderProperties();
    }

    @Bean
    public MessageService getMessageSenderService() {
        MessagesenderProperties properties = this.getProperties();
        if (ObjectUtils.isEmpty(properties.getWechat_webhooks())) {
            log.error("\u52a0\u8f7dwebhook\u2014api\u9ed8\u8ba4\u914d\u7f6e\u5931\u8d25");
            throw new RuntimeException("webhook\u2014api\u6ca1\u6709\u9ed8\u8ba4\u914d\u7f6e");
        }
        log.info("\u5df2\u6210\u529f\u52a0\u8f7d[{}]\u4e2awebhook\u2014api\u9ed8\u8ba4\u914d\u7f6e", (Object)properties.getWechat_webhooks().size());
        return new MessageServiceImpl(properties);
    }
}

