/*
 * Decompiled with CFR 0.152.
 */
package com.sayalala.wework.wehook.entity;

import com.sayalala.wework.wehook.entity.Article;
import com.sayalala.wework.wehook.utils.Fileutils;
import com.sayalala.wework.wehook.utils.IDUtils;
import com.sayalala.wework.wehook.utils.ImageToBase64;
import com.sayalala.wework.wehook.utils.MD5Utils;
import com.sayalala.wework.wehook.utils.MarkdownBuffer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WeWorkWebhookMessage {
    private String webhook;
    private String msgtype;
    private Text text;
    private Markdown markdown;
    private Image image;
    private News news;

    public static WeWorkWebhookMessage buildImageMessage(String imagePath) {
        try {
            WeWorkWebhookMessage message = new WeWorkWebhookMessage();
            message.setMsgtype("image");
            Image image = new Image();
            if (imagePath.startsWith("http")) {
                File file = Fileutils.downloadFile(imagePath, "image", IDUtils.genRandom("image-", 15));
                image.setBase64(ImageToBase64.ImageToBase64(file));
                image.setMd5(MD5Utils.getfilemd5String(file));
                message.setImage(image);
                Fileutils.keepTop(file, 1);
            } else {
                File file = new File(imagePath);
                image.setBase64(ImageToBase64.ImageToBase64(file));
                image.setMd5(MD5Utils.getfilemd5String(file));
                message.setImage(image);
            }
            return message;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static WeWorkWebhookMessage buildMarkDownMessage(MarkdownBuffer content) {
        WeWorkWebhookMessage message = new WeWorkWebhookMessage();
        message.setMsgtype("markdown");
        Markdown markdown = new Markdown();
        markdown.setContent(content.toString());
        message.setMarkdown(markdown);
        return message;
    }

    public static WeWorkWebhookMessage buildNewsMessage(List<Article> articles) {
        WeWorkWebhookMessage message = new WeWorkWebhookMessage();
        message.setMsgtype("news");
        News news = new News();
        news.setArticles(articles);
        message.setNews(news);
        return message;
    }

    public static WeWorkWebhookMessage buildNewsMessage(Article article) {
        WeWorkWebhookMessage message = new WeWorkWebhookMessage();
        message.setMsgtype("news");
        News news = new News();
        ArrayList<Article> list = new ArrayList<Article>();
        list.add(article);
        news.setArticles(list);
        message.setNews(news);
        return message;
    }

    public static WeWorkWebhookMessage buildText(String content) {
        return WeWorkWebhookMessage.buildText(content, false);
    }

    public static WeWorkWebhookMessage buildText(String content, boolean atAll) {
        WeWorkWebhookMessage message = new WeWorkWebhookMessage();
        message.setMsgtype("text");
        Text text = new Text();
        text.setContent(content);
        List<String> mentioned_list = text.getMentioned_list();
        if (atAll) {
            if (mentioned_list == null) {
                mentioned_list = new ArrayList<String>();
            }
            mentioned_list.add("@all");
            text.setMentioned_list(mentioned_list);
        }
        message.setText(text);
        return message;
    }

    public String getWebhook() {
        return this.webhook;
    }

    public String getMsgtype() {
        return this.msgtype;
    }

    public Text getText() {
        return this.text;
    }

    public Markdown getMarkdown() {
        return this.markdown;
    }

    public Image getImage() {
        return this.image;
    }

    public News getNews() {
        return this.news;
    }

    public WeWorkWebhookMessage setWebhook(String webhook) {
        this.webhook = webhook;
        return this;
    }

    public WeWorkWebhookMessage setMsgtype(String msgtype) {
        this.msgtype = msgtype;
        return this;
    }

    public WeWorkWebhookMessage setText(Text text) {
        this.text = text;
        return this;
    }

    public WeWorkWebhookMessage setMarkdown(Markdown markdown) {
        this.markdown = markdown;
        return this;
    }

    public WeWorkWebhookMessage setImage(Image image) {
        this.image = image;
        return this;
    }

    public WeWorkWebhookMessage setNews(News news) {
        this.news = news;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeWorkWebhookMessage)) {
            return false;
        }
        WeWorkWebhookMessage other = (WeWorkWebhookMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$webhook = this.getWebhook();
        String other$webhook = other.getWebhook();
        if (this$webhook == null ? other$webhook != null : !this$webhook.equals(other$webhook)) {
            return false;
        }
        String this$msgtype = this.getMsgtype();
        String other$msgtype = other.getMsgtype();
        if (this$msgtype == null ? other$msgtype != null : !this$msgtype.equals(other$msgtype)) {
            return false;
        }
        Text this$text = this.getText();
        Text other$text = other.getText();
        if (this$text == null ? other$text != null : !((Object)this$text).equals(other$text)) {
            return false;
        }
        Markdown this$markdown = this.getMarkdown();
        Markdown other$markdown = other.getMarkdown();
        if (this$markdown == null ? other$markdown != null : !((Object)this$markdown).equals(other$markdown)) {
            return false;
        }
        Image this$image = this.getImage();
        Image other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        News this$news = this.getNews();
        News other$news = other.getNews();
        return !(this$news == null ? other$news != null : !((Object)this$news).equals(other$news));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeWorkWebhookMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $webhook = this.getWebhook();
        result = result * 59 + ($webhook == null ? 43 : $webhook.hashCode());
        String $msgtype = this.getMsgtype();
        result = result * 59 + ($msgtype == null ? 43 : $msgtype.hashCode());
        Text $text = this.getText();
        result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
        Markdown $markdown = this.getMarkdown();
        result = result * 59 + ($markdown == null ? 43 : ((Object)$markdown).hashCode());
        Image $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        News $news = this.getNews();
        result = result * 59 + ($news == null ? 43 : ((Object)$news).hashCode());
        return result;
    }

    public String toString() {
        return "WeWorkWebhookMessage(webhook=" + this.getWebhook() + ", msgtype=" + this.getMsgtype() + ", text=" + this.getText() + ", markdown=" + this.getMarkdown() + ", image=" + this.getImage() + ", news=" + this.getNews() + ")";
    }

    public static class News {
        private List<Article> articles;

        public List<Article> getArticles() {
            return this.articles;
        }

        public News setArticles(List<Article> articles) {
            this.articles = articles;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof News)) {
                return false;
            }
            News other = (News)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Article> this$articles = this.getArticles();
            List<Article> other$articles = other.getArticles();
            return !(this$articles == null ? other$articles != null : !((Object)this$articles).equals(other$articles));
        }

        protected boolean canEqual(Object other) {
            return other instanceof News;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Article> $articles = this.getArticles();
            result = result * 59 + ($articles == null ? 43 : ((Object)$articles).hashCode());
            return result;
        }

        public String toString() {
            return "WeWorkWebhookMessage.News(articles=" + this.getArticles() + ")";
        }
    }

    public static class Image {
        private String base64;
        private String md5;

        public String getBase64() {
            return this.base64;
        }

        public String getMd5() {
            return this.md5;
        }

        public Image setBase64(String base64) {
            this.base64 = base64;
            return this;
        }

        public Image setMd5(String md5) {
            this.md5 = md5;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Image)) {
                return false;
            }
            Image other = (Image)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$base64 = this.getBase64();
            String other$base64 = other.getBase64();
            if (this$base64 == null ? other$base64 != null : !this$base64.equals(other$base64)) {
                return false;
            }
            String this$md5 = this.getMd5();
            String other$md5 = other.getMd5();
            return !(this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Image;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $base64 = this.getBase64();
            result = result * 59 + ($base64 == null ? 43 : $base64.hashCode());
            String $md5 = this.getMd5();
            result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
            return result;
        }

        public String toString() {
            return "WeWorkWebhookMessage.Image(base64=" + this.getBase64() + ", md5=" + this.getMd5() + ")";
        }
    }

    public static class Markdown {
        private String content;

        public String getContent() {
            return this.content;
        }

        public Markdown setContent(String content) {
            this.content = content;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Markdown)) {
                return false;
            }
            Markdown other = (Markdown)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Markdown;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        public String toString() {
            return "WeWorkWebhookMessage.Markdown(content=" + this.getContent() + ")";
        }
    }

    public static class Text {
        private String content;
        private List<String> mentioned_list;

        public String getContent() {
            return this.content;
        }

        public List<String> getMentioned_list() {
            return this.mentioned_list;
        }

        public Text setContent(String content) {
            this.content = content;
            return this;
        }

        public Text setMentioned_list(List<String> mentioned_list) {
            this.mentioned_list = mentioned_list;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Text)) {
                return false;
            }
            Text other = (Text)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            List<String> this$mentioned_list = this.getMentioned_list();
            List<String> other$mentioned_list = other.getMentioned_list();
            return !(this$mentioned_list == null ? other$mentioned_list != null : !((Object)this$mentioned_list).equals(other$mentioned_list));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Text;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            List<String> $mentioned_list = this.getMentioned_list();
            result = result * 59 + ($mentioned_list == null ? 43 : ((Object)$mentioned_list).hashCode());
            return result;
        }

        public String toString() {
            return "WeWorkWebhookMessage.Text(content=" + this.getContent() + ", mentioned_list=" + this.getMentioned_list() + ")";
        }
    }
}

