/*
 * Decompiled with CFR 0.152.
 */
package com.sayalala.wework.wehook.service;

import com.alibaba.fastjson.JSONObject;
import com.sayalala.wework.wehook.config.MessagesenderProperties;
import com.sayalala.wework.wehook.entity.WeWorkWebhookMessage;
import com.sayalala.wework.wehook.service.MessageService;
import com.sayalala.wework.wehook.utils.HttpClientUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MessageServiceImpl
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    private List<String> wechat_webhooks;

    public MessageServiceImpl(MessagesenderProperties messagesenderProperties) {
        this.wechat_webhooks = messagesenderProperties.getWechat_webhooks();
        if (this.wechat_webhooks == null || this.wechat_webhooks.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709wechatwebhook\u914d\u7f6e");
        }
    }

    @Override
    public boolean send(WeWorkWebhookMessage weWorkWebhookMessage) {
        return this.send(weWorkWebhookMessage, this.wechat_webhooks.get(0));
    }

    @Override
    public boolean send(WeWorkWebhookMessage weWorkWebhookMessage, String webhook) {
        if (StringUtils.isEmpty((Object)webhook)) {
            throw new RuntimeException("webhook\u5730\u5740\u4e3a\u7a7a");
        }
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Content-Type", "application/json");
        headerParams.put("charset", "utf-8");
        String responseStr = HttpClientUtil.doPostJson(webhook, headerParams, JSONObject.toJSONString((Object)weWorkWebhookMessage));
        if (JSONObject.parseObject((String)responseStr).getString("errmsg").equals("ok")) {
            log.info("\u4f01\u4e1a\u5fae\u4fe1webhook\u6d88\u606f\u53d1\u9001\u6210\u529f");
            log.debug("webhook\u5730\u5740\u4e3a\uff1a[{}]", (Object)webhook);
            log.debug("\u6d88\u606f\u5185\u5bb9\u4e3a\uff1a[{}]", (Object)JSONObject.toJSONString((Object)weWorkWebhookMessage, (boolean)true));
            log.debug("\u54cd\u5e94\u4e3a\uff1a[{}]", (Object)responseStr);
            return true;
        }
        log.error("\u4f01\u4e1a\u5fae\u4fe1webhook\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        log.error("webhook\u5730\u5740\u4e3a\uff1a[{}]", (Object)webhook);
        log.error("\u6d88\u606f\u5185\u5bb9\u4e3a\uff1a[{}]", (Object)JSONObject.toJSONString((Object)weWorkWebhookMessage, (boolean)true));
        log.error("\u54cd\u5e94\u4e3a\uff1a[{}]", (Object)responseStr);
        return false;
    }
}

