/*
 * Decompiled with CFR 0.152.
 */
package com.sayalala.wework.wehook.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class Fileutils {
    private static Logger logger = Logger.getLogger(Fileutils.class.getName());

    public static File downloadFile(String urlPath, String folderName, String fileName) throws Exception {
        File folder = new File(folderName);
        if (!folder.exists()) {
            folder.mkdir();
        }
        File file = new File(folder + File.separator + fileName);
        BufferedInputStream bin = null;
        OutputStream out = null;
        try {
            URL url = new URL(urlPath);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            int fileLength = httpURLConnection.getContentLength();
            String filePathUrl = httpURLConnection.getURL().getFile();
            String fileFullName = filePathUrl.substring(filePathUrl.lastIndexOf(File.separatorChar) + 1);
            fileFullName = fileFullName.substring(fileFullName.lastIndexOf("/") + 1);
            url.openConnection();
            bin = new BufferedInputStream(httpURLConnection.getInputStream());
            out = new FileOutputStream(file);
            int size = 0;
            int len = 0;
            byte[] buf = new byte[1024];
            while ((size = bin.read(buf)) != -1) {
                len += size;
                out.write(buf, 0, size);
            }
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString() + "\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u4e0b\u8f7d\u94fe\u63a5$$" + urlPath);
        }
        finally {
            if (bin != null) {
                bin.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void keepTop(File file, int max) {
        File[] files = file.getParentFile().listFiles();
        if (files.length > max) {
            ArrayList<File> list = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                list.add(files[i]);
            }
            AtomicInteger removeCounter = new AtomicInteger(files.length - max);
            list.stream().sorted(Comparator.comparingLong(File::lastModified)).forEach(ele -> {
                if (removeCounter.get() > 0) {
                    ele.delete();
                }
                removeCounter.getAndDecrement();
            });
        }
    }
}

