/*
 * Decompiled with CFR 0.152.
 */
package com.sayalala.wework.wehook.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    protected static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected static MessageDigest messagedigest = null;

    private static String getMD5String(String s) {
        return MD5Utils.getMD5String(s.getBytes());
    }

    public static boolean checkPassword(String password, String md5PwdStr) {
        String s = MD5Utils.getMD5String(password);
        return s.equals(md5PwdStr);
    }

    public static String getfilemd5String(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        int numRead = 0;
        while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
            messagedigest.update(buffer, 0, numRead);
        }
        ((InputStream)fis).close();
        return MD5Utils.bufferToHex(messagedigest.digest());
    }

    public static String getFileMD5String_old(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        FileChannel ch = in.getChannel();
        MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        messagedigest.update(byteBuffer);
        in.close();
        return MD5Utils.bufferToHex(messagedigest.digest());
    }

    private static String getMD5String(byte[] bytes) {
        messagedigest.update(bytes);
        return MD5Utils.bufferToHex(messagedigest.digest());
    }

    private static String bufferToHex(byte[] bytes) {
        return MD5Utils.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            MD5Utils.appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = hexDigits[(bt & 0xF0) >> 4];
        char c1 = hexDigits[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }

    public static void main(String[] args) throws IOException {
        long begin = System.currentTimeMillis();
        File file = new File("D:/BaiduNetdiskDownload/01_SpringBoot\u5168\u5957\u89c6\u9891\u6559\u7a0b2018\u5e743\u6708\u4efd\u5f55\u52362.0.x\u7248\u672c/01-SpringBoot\u7b80\u4ecb.avi");
        if (!file.exists()) {
            System.out.println("\u4e0d\u5b58\u5728");
        }
        String md5 = MD5Utils.getfilemd5String(file);
        String md5_a = MD5Utils.getMD5String("a");
        long end = System.currentTimeMillis();
        System.out.println("md5:" + md5 + " time:" + (end - begin) / 1000L + "s");
        System.out.println(file.getPath());
    }

    public static String getNetFileMD5String(String imagePath) {
        try {
            URL url = new URL(imagePath);
            byte[] by = new byte[1024];
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            InputStream is = conn.getInputStream();
            File temp = File.createTempFile("temp", ".img");
            FileOutputStream outputStream = new FileOutputStream(temp);
            int len = -1;
            while ((len = is.read(by)) != -1) {
                outputStream.write(by, 0, len);
            }
            is.close();
            outputStream.close();
            String md5String = MD5Utils.getfilemd5String(temp);
            temp.delete();
            return md5String;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsaex) {
            System.err.println(MD5Utils.class.getName() + "\u521d\u59cb\u5316\u5931\u8d25\uff0cMessageDigest\u4e0d\u652f\u6301MD5Util\u3002");
            nsaex.printStackTrace();
        }
    }
}

