/*
 * Decompiled with CFR 0.152.
 */
package com.sayalala.wework.wehook.utils;

public class MarkdownBuffer {
    private static final String NEXT_LINE = "\n";
    private StringBuffer buffer = new StringBuffer();

    public MarkdownBuffer h6(String text) {
        this.buffer.append("###### " + text);
        return this;
    }

    public MarkdownBuffer h5(String text) {
        this.buffer.append("##### " + text);
        return this;
    }

    public MarkdownBuffer h4(String text) {
        this.buffer.append("#### " + text);
        return this;
    }

    public MarkdownBuffer h3(String text) {
        this.buffer.append("### " + text);
        return this;
    }

    public MarkdownBuffer h2(String text) {
        this.buffer.append("## " + text);
        return this;
    }

    public MarkdownBuffer h1(String h1Text) {
        this.buffer.append("# " + h1Text);
        return this;
    }

    public MarkdownBuffer code(String code) {
        this.buffer.append("`" + code + "`");
        return this;
    }

    public MarkdownBuffer link(String link, String url) {
        this.buffer.append("[" + link + "](" + url + ")");
        return this;
    }

    public MarkdownBuffer text(String text) {
        this.buffer.append(text);
        return this;
    }

    public MarkdownBuffer quote(String text) {
        this.buffer.append("> " + text);
        return this;
    }

    public MarkdownBuffer orange(String orangeText) {
        this.buffer.append("<font color=\"warning\">" + orangeText + "</font>");
        return this;
    }

    public MarkdownBuffer green(String greenText) {
        this.buffer.append("<font color=\"info\">" + greenText + "</font>");
        return this;
    }

    public MarkdownBuffer gray(String grayText) {
        this.buffer.append("<font color=\"comment\">" + grayText + "</font>");
        return this;
    }

    public MarkdownBuffer bold(String boldText) {
        this.buffer.append("**" + boldText + "**");
        return this;
    }

    public MarkdownBuffer nextLine() {
        this.buffer.append(NEXT_LINE);
        return this;
    }

    public MarkdownBuffer quoteEnd() {
        this.buffer.append(NEXT_LINE).append(NEXT_LINE);
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

