/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins;

import cn.wwwlike.plugins.FileSync;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

public class AbstractProcessorMojo
extends AbstractMojo {
    private static final String JAVA_FILE_FILTER = "/*.java";
    private static final String[] ALL_JAVA_FILES_FILTER = new String[]{"**/*.java"};
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    private String[] processors;
    private String processor;
    private String sourceEncoding;
    private Map<String, String> options;
    private Map<String, String> compilerOptions;
    private Set<String> includes = new HashSet<String>();
    private boolean showWarnings = false;
    private boolean logOnlyOnError = false;
    private List<Artifact> pluginArtifacts;
    private List<String> additionalSourceRoots;
    private List<String> additionalTestSourceRoots;
    private boolean ignoreDelta = true;

    private String buildCompileClasspath() {
        List pathElements = null;
        try {
            pathElements = this.isForTest() ? this.project.getTestClasspathElements() : this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            super.getLog().warn((CharSequence)"exception calling getCompileClasspathElements", (Throwable)e);
            return null;
        }
        if (this.pluginArtifacts != null) {
            for (Artifact a : this.pluginArtifacts) {
                if (a.getFile() == null) continue;
                pathElements.add(a.getFile().getAbsolutePath());
            }
        }
        if (pathElements.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (i = 0; i < pathElements.size() - 1; ++i) {
            result.append((String)pathElements.get(i)).append(File.pathSeparatorChar);
        }
        result.append((String)pathElements.get(i));
        return result.toString();
    }

    private String buildProcessor() {
        if (this.processors != null) {
            StringBuilder result = new StringBuilder();
            for (String processor : this.processors) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(processor);
            }
            return result.toString();
        }
        if (this.processor != null) {
            return this.processor;
        }
        String error = "Either processor or processors need to be given";
        this.getLog().error((CharSequence)error);
        throw new IllegalArgumentException(error);
    }

    private List<String> buildCompilerOptions(String processor, String compileClassPath, String outputDirectory) throws IOException {
        LinkedHashMap<String, String> compilerOpts = new LinkedHashMap<String, String>();
        compilerOpts.put("cp", compileClassPath);
        if (this.sourceEncoding != null) {
            compilerOpts.put("encoding", this.sourceEncoding);
        }
        compilerOpts.put("proc:only", null);
        compilerOpts.put("processor", processor);
        if (this.options != null) {
            for (Map.Entry<String, String> entry : this.options.entrySet()) {
                if (entry.getValue() != null) {
                    compilerOpts.put("A" + (String)entry.getKey() + "=" + (String)entry.getValue(), null);
                    continue;
                }
                compilerOpts.put("A" + (String)entry.getKey() + "=", null);
            }
        }
        if (outputDirectory != null) {
            compilerOpts.put("s", outputDirectory);
        }
        if (!this.showWarnings) {
            compilerOpts.put("nowarn", null);
        }
        StringBuilder builder = new StringBuilder();
        for (File file : this.getSourceDirectories()) {
            if (builder.length() > 0) {
                builder.append(";");
            }
            builder.append(file.getCanonicalPath());
        }
        compilerOpts.put("sourcepath", builder.toString());
        if (this.compilerOptions != null) {
            compilerOpts.putAll(this.compilerOptions);
        }
        ArrayList<String> opts = new ArrayList<String>(compilerOpts.size() * 2);
        for (Map.Entry compilerOption : compilerOpts.entrySet()) {
            opts.add("-" + (String)compilerOption.getKey());
            String value = (String)compilerOption.getValue();
            if (!StringUtils.isNotBlank((String)value)) continue;
            opts.add(value);
        }
        return opts;
    }

    private Set<File> filterFiles(Set<File> directories) {
        String[] filters = ALL_JAVA_FILES_FILTER;
        if (this.includes != null && !this.includes.isEmpty()) {
            filters = this.includes.toArray(new String[this.includes.size()]);
            for (int i = 0; i < filters.length; ++i) {
                filters[i] = filters[i].replace('.', '/') + JAVA_FILE_FILTER;
            }
        }
        HashSet<File> files = new HashSet<File>();
        for (File directory : directories) {
            Scanner scanner = this.buildContext.newScanner(directory, false);
            scanner.setIncludes(filters);
            scanner.scan();
            String[] includedFiles = scanner.getIncludedFiles();
            if (this.buildContext.isIncremental() && (includedFiles == null || includedFiles.length == 0)) {
                scanner = this.buildContext.newDeleteScanner(directory);
                scanner.setIncludes(filters);
                scanner.scan();
                includedFiles = scanner.getIncludedFiles();
            }
            if (this.ignoreDelta && this.buildContext.isIncremental() && includedFiles != null && includedFiles.length > 0) {
                scanner = this.buildContext.newScanner(directory, true);
                scanner.setIncludes(filters);
                scanner.scan();
                includedFiles = scanner.getIncludedFiles();
            }
            if (includedFiles == null) continue;
            for (String includedFile : includedFiles) {
                files.add(new File(scanner.getBasedir(), includedFile));
            }
        }
        return files;
    }

    private void processDiagnostics(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        for (Diagnostic<? extends JavaFileObject> diagnostic : diagnostics) {
            JavaFileObject javaFileObject = diagnostic.getSource();
            if (javaFileObject == null) continue;
            File file = new File(javaFileObject.toUri().getPath());
            Diagnostic.Kind kind = diagnostic.getKind();
            int lineNumber = (int)diagnostic.getLineNumber();
            int columnNumber = (int)diagnostic.getColumnNumber();
            String message = diagnostic.getMessage(Locale.getDefault());
            switch (kind) {
                case ERROR: {
                    this.buildContext.addMessage(file, lineNumber, columnNumber, message, 2, null);
                    break;
                }
                case WARNING: 
                case MANDATORY_WARNING: {
                    this.buildContext.addMessage(file, lineNumber, columnNumber, message, 1, null);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.getOutputDirectory() == null) {
            return;
        }
        if ("true".equals(System.getProperty("maven.apt.skip"))) {
            return;
        }
        if (!this.getOutputDirectory().exists()) {
            this.getOutputDirectory().mkdirs();
        }
        if (this.isForTest()) {
            this.project.addTestCompileSourceRoot(this.getOutputDirectory().getAbsolutePath());
        } else {
            this.project.addCompileSourceRoot(this.getOutputDirectory().getAbsolutePath());
        }
        Set<File> sourceDirectories = this.getSourceDirectories();
        this.getLog().debug((CharSequence)("Using build context: " + this.buildContext));
        JavaFileManager fileManager = null;
        try {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                throw new MojoExecutionException("You need to run build with JDK or have tools.jar on the classpath.If this occures during eclipse build make sure you run eclipse under JDK as well");
            }
            Set<File> files = this.filterFiles(sourceDirectories);
            if (files.isEmpty()) {
                this.getLog().debug((CharSequence)"No Java sources found (skipping)");
                return;
            }
            fileManager = compiler.getStandardFileManager(null, null, null);
            Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(files);
            for (JavaFileObject javaFileObject : compilationUnits1) {
                this.buildContext.removeMessages(new File(javaFileObject.toUri().getPath()));
            }
            String compileClassPath = this.buildCompileClasspath();
            String string = this.buildProcessor();
            String outputDirectory = this.getOutputDirectory().getPath();
            File tempDirectory = null;
            if (this.buildContext.isIncremental()) {
                tempDirectory = new File(this.project.getBuild().getDirectory(), "apt" + System.currentTimeMillis());
                tempDirectory.mkdirs();
                outputDirectory = tempDirectory.getAbsolutePath();
            }
            List<String> compilerOptions = this.buildCompilerOptions(string, compileClassPath, outputDirectory);
            StringWriter out = null;
            if (this.logOnlyOnError) {
                out = new StringWriter();
            }
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
                JavaCompiler.CompilationTask task = compiler.getTask(out, fileManager, diagnosticCollector, compilerOptions, null, compilationUnits1);
                Future<Boolean> future = executor.submit(task);
                Boolean rv = future.get();
                if (Boolean.FALSE.equals(rv) && this.logOnlyOnError) {
                    this.getLog().error((CharSequence)((Object)out).toString());
                }
                this.processDiagnostics(diagnosticCollector.getDiagnostics());
            }
            finally {
                executor.shutdown();
                if (tempDirectory != null) {
                    FileSync.syncFiles(tempDirectory, this.getOutputDirectory());
                    FileUtils.deleteDirectory((File)tempDirectory);
                }
            }
            this.buildContext.refresh(this.getOutputDirectory());
        }
        catch (Exception e1) {
            this.getLog().error((CharSequence)"execute error", (Throwable)e1);
            throw new MojoExecutionException(e1.getMessage(), e1);
        }
        finally {
            if (fileManager != null) {
                try {
                    fileManager.close();
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)"Unable to close fileManager", (Throwable)e);
                }
            }
        }
    }

    protected File getOutputDirectory() {
        return new File("D:/wwwlike/vlife");
    }

    protected Set<File> getSourceDirectories() {
        File outputDirectory = this.getOutputDirectory();
        String outputPath = outputDirectory.getAbsolutePath();
        HashSet<File> directories = new HashSet<File>();
        List<String> directoryNames = this.isForTest() ? this.getTestCompileSourceRoots() : this.getCompileSourceRoots();
        for (String name : directoryNames) {
            File file = new File(name);
            if (file.getAbsolutePath().equals(outputPath) || !file.exists() || !file.isDirectory()) continue;
            directories.add(file);
        }
        return directories;
    }

    private List<String> getTestCompileSourceRoots() {
        List testCompileSourceRoots = this.project.getTestCompileSourceRoots();
        if (this.additionalTestSourceRoots == null) {
            return testCompileSourceRoots;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Adding additional test source roots: " + Joiner.on((String)", ").skipNulls().join(this.additionalTestSourceRoots)));
        }
        ArrayList<String> sourceRoots = new ArrayList<String>(testCompileSourceRoots);
        sourceRoots.addAll(this.additionalTestSourceRoots);
        return sourceRoots;
    }

    private List<String> getCompileSourceRoots() {
        List compileSourceRoots = this.project.getCompileSourceRoots();
        if (this.additionalSourceRoots == null) {
            return compileSourceRoots;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Adding additional source roots: " + Joiner.on((String)", ").skipNulls().join(this.additionalSourceRoots)));
        }
        ArrayList<String> sourceRoots = new ArrayList<String>(compileSourceRoots);
        sourceRoots.addAll(this.additionalSourceRoots);
        return sourceRoots;
    }

    protected boolean isForTest() {
        return false;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setProcessors(String[] processors) {
        this.processors = processors;
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public void setCompilerOptions(Map<String, String> compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public void setIncludes(Set<String> includes) {
        this.includes = includes;
    }

    public void setShowWarnings(boolean showWarnings) {
        this.showWarnings = showWarnings;
    }

    public void setLogOnlyOnError(boolean logOnlyOnError) {
        this.logOnlyOnError = logOnlyOnError;
    }

    public void setPluginArtifacts(List<Artifact> pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }
}

