/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins;

import cn.wwwlike.plugins.utils.FileUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class JavaToTypeScript
extends AbstractMojo {
    static final ClassLoader CLASS_LOADER = JavaToTypeScript.class.getClassLoader();
    static final String BASE_PATH = CLASS_LOADER.getResource("").getPath().substring(1);
    static final Map<String, String> TYPE_MAP = new HashMap<String, String>();
    static Class superClass;
    static List<String> superClassFieldNameList;

    public static String loadSuperClass() throws ClassNotFoundException {
        try {
            List fieldNameList = FieldUtils.getAllFieldsList((Class)superClass).stream().map(field -> field.getName()).collect(Collectors.toList());
            superClassFieldNameList.addAll(fieldNameList);
            return JavaToTypeScript.getTypeScript(superClass, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getTypeScript(Class clazz) {
        return JavaToTypeScript.getTypeScript(clazz, false);
    }

    public static String getTypeScript(Class clazz, boolean isSupperClass) {
        String template = "interface =className= {\n=typeBody=\n}\n";
        if (Objects.nonNull(superClass) && !isSupperClass) {
            template = "interface =className= extends =superClassName= {\n=typeBody=\n}\n".replaceAll("=superClassName=", superClass.getSimpleName());
        }
        String typeTemplate = "     // =remark=\n     =fieldName=?: =typeName=";
        String typeBody = FieldUtils.getAllFieldsList((Class)clazz).stream().filter(field -> {
            String fieldName = field.getName();
            String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                clazz.getMethod(setMethodName, field.getType());
                clazz.getMethod(getMethodName, new Class[0]);
                if (isSupperClass) {
                    return true;
                }
                return !superClassFieldNameList.contains(field.getName());
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }).map(field -> typeTemplate.replaceAll("=fieldName=", field.getName()).replaceAll("=typeName=", TYPE_MAP.get(field.getType().getSimpleName())).replaceAll("=remark=", JavaToTypeScript.getFieldRemark(field))).collect(Collectors.joining("\n"));
        return template.replaceAll("=className=", clazz.getSimpleName()).replaceAll("=typeBody=", typeBody);
    }

    public static String getFieldRemark(Field field) {
        return null;
    }

    public static List<Class<?>> getAllClass(List<String> files) {
        String basePath = Paths.get(BASE_PATH, new String[0]).toString();
        return files.stream().map(filePath -> {
            filePath = Paths.get(filePath, new String[0]).toString();
            String packageName = filePath.replace(basePath, "").substring(1).replaceAll("\\.class", "").replaceAll(File.separator + File.separator, ".");
            try {
                return CLASS_LOADER.loadClass(packageName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(item -> Objects.nonNull(item)).collect(Collectors.toList());
    }

    public static List<String> getAllJavaFile(File file, List<String> files) {
        if (!file.isDirectory()) {
            return files;
        }
        file.listFiles(file1 -> {
            if (file1.isDirectory()) {
                JavaToTypeScript.getAllJavaFile(file1, files);
            } else {
                String name = file1.getName();
                if (name.toLowerCase().endsWith(".class")) {
                    files.add(file1.getAbsolutePath());
                }
            }
            return false;
        });
        return files;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String superClassTypeStr = JavaToTypeScript.loadSuperClass();
        String packageName = "com.cai.orderingfood.common.model.entity";
        URL url = CLASS_LOADER.getResource(packageName.replaceAll("\\.", "/"));
        List<String> allJavaFile = JavaToTypeScript.getAllJavaFile(new File(url.getPath()), new ArrayList<String>());
        List<Class<?>> allClass = JavaToTypeScript.getAllClass(allJavaFile);
        String result = allClass.stream().map(clazz -> JavaToTypeScript.getTypeScript(clazz)).collect(Collectors.joining("\n"));
        File file = new File(BASE_PATH + "type.d.ts");
        if (file.exists()) {
            file.delete();
        }
        FileUtil.nioWriteFile(superClassTypeStr, BASE_PATH + "type.d.ts");
    }

    static {
        superClassFieldNameList = new ArrayList<String>();
        TYPE_MAP.put("Integer", "number");
        TYPE_MAP.put("String", "string");
        TYPE_MAP.put("Date", "string");
        TYPE_MAP.put("DateTime", "string");
        TYPE_MAP.put("BigDecimal", "number");
        try {
            superClass = CLASS_LOADER.loadClass("com.cai.orderingfood.common.base.BaseEntity");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

