/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins;

import cn.wwwlike.plugins.generator.GeneratorMaster;
import cn.wwwlike.plugins.generator.GeneratorTableDict;
import cn.wwwlike.plugins.utils.ClassLoaderUtil;
import cn.wwwlike.vlife.objship.read.ModelReadCheck;
import com.squareup.javapoet.JavaFile;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="codeCreate", defaultPhase=LifecyclePhase.INSTALL)
public class MvcCodeCreateMojo
extends AbstractMojo {
    @Parameter
    private List<String> entityPackages;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        List sourceRoots = this.project.getCompileSourceRoots();
        ClassLoader loader = ClassLoaderUtil.getRuntimeClassLoader(this.project);
        ModelReadCheck modelReadCheck = new ModelReadCheck();
        int errorNum = modelReadCheck.load(loader);
        GeneratorMaster generatorMaster = new GeneratorMaster();
        if (errorNum == 0) {
            try {
                for (String sourceRoot : sourceRoots) {
                    if (sourceRoot.indexOf("target") != -1) continue;
                    List<JavaFile> mvcFiles = generatorMaster.generator(sourceRoot, loader, modelReadCheck.getItemDtos(), modelReadCheck.getVoDtos(), modelReadCheck.getReqDtos(), modelReadCheck.getSaveDtos());
                    generatorMaster.createJavaFiles(sourceRoot, false, mvcFiles);
                }
                GeneratorTableDict tableDict = new GeneratorTableDict();
                List<JavaFile> dictFiles = tableDict.generator(modelReadCheck.getItemDtos(), modelReadCheck.getVoDtos(), modelReadCheck.getReqDtos());
                String dicgTarget = this.project.getBasedir().getPath() + "/target/generated-sources/java";
                generatorMaster.createJavaFiles(dicgTarget, true, dictFiles);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            modelReadCheck.getLogger().error("\u6a21\u578b\u4fe1\u606f\u8bfb\u53d6\u5b58\u5728\u9519\u8bef,\u4ee3\u7801\u751f\u6210\u5931\u8d25");
        }
    }
}

