/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins;

import cn.wwwlike.plugins.constant.comment.CommentParser;
import cn.wwwlike.plugins.utils.ClassLoaderUtil;
import cn.wwwlike.plugins.utils.FileUtil;
import cn.wwwlike.plugins.utils.JsonUtil;
import cn.wwwlike.vlife.objship.read.ModelReadCheck;
import cn.wwwlike.vlife.objship.read.tag.ClzTag;
import cn.wwwlike.vlife.objship.read.tag.FieldTag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="titleJson", defaultPhase=LifecyclePhase.INSTALL)
public class TitleJsonCreateMojo
extends AbstractMojo {
    @Parameter
    private List<String> entityPackages;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList files = new ArrayList();
        ModelReadCheck modelReadCheck = new ModelReadCheck();
        ClassLoader loader = ClassLoaderUtil.getRuntimeClassLoader(this.project);
        int errorNum = modelReadCheck.load(loader);
        if (errorNum == 0) {
            try {
                String srcPath = "";
                files.addAll(FileUtils.getFiles((File)new File(this.project.getBasedir() + "/src/main/java" + srcPath), null, null));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ArrayList<ClzTag> tags = new ArrayList<ClzTag>();
            HashMap<String, FieldTag> dbEntityFieldTag = new HashMap<String, FieldTag>();
            FieldTag idTag = new FieldTag();
            idTag.setTitle("\u4e3b\u952eid");
            idTag.setFieldName("id");
            idTag.setFieldType("string");
            idTag.setExtendsField(Boolean.valueOf(true));
            dbEntityFieldTag.put("id", idTag);
            FieldTag statusTag = new FieldTag();
            statusTag.setTitle("\u5220\u9664\u72b6\u6001");
            statusTag.setExtendsField(Boolean.valueOf(true));
            statusTag.setFieldName("status");
            statusTag.setFieldType("string");
            dbEntityFieldTag.put("status", statusTag);
            FieldTag createDateTag = new FieldTag();
            createDateTag.setExtendsField(Boolean.valueOf(true));
            createDateTag.setTitle("\u521b\u5efa\u65f6\u95f4");
            createDateTag.setFieldName("status");
            createDateTag.setFieldType("Date");
            dbEntityFieldTag.put("createDate", createDateTag);
            FieldTag modifyDateTag = new FieldTag();
            modifyDateTag.setExtendsField(Boolean.valueOf(true));
            modifyDateTag.setTitle("\u4fee\u6539\u65f6\u95f4");
            modifyDateTag.setFieldName("modifyDate");
            modifyDateTag.setFieldType("Date");
            dbEntityFieldTag.put("modifyDate", modifyDateTag);
            FieldTag modifyIdTag = new FieldTag();
            modifyIdTag.setExtendsField(Boolean.valueOf(true));
            modifyIdTag.setTitle("\u4fee\u8ba2\u4eba");
            modifyIdTag.setFieldType("string");
            modifyIdTag.setFieldName("modifyId");
            dbEntityFieldTag.put("modifyId", modifyIdTag);
            FieldTag createIdTag = new FieldTag();
            createIdTag.setExtendsField(Boolean.valueOf(true));
            createIdTag.setTitle("\u521b\u5efa\u4eba");
            createIdTag.setFieldName("createId");
            createIdTag.setFieldType("string");
            dbEntityFieldTag.put("createId", createIdTag);
            for (File path : files) {
                ClzTag tag = CommentParser.parserField(path, modelReadCheck);
                if (tag == null) continue;
                tags.add(tag);
            }
            for (ClzTag tag : tags) {
                if (!"DbEntity".equals(tag.getSuperName())) continue;
                if (tag.getTags() == null) {
                    tag.setTags(dbEntityFieldTag);
                    continue;
                }
                dbEntityFieldTag.forEach((key, val) -> {
                    if (tag.getTags().get(key) == null) {
                        tag.getTags().put(key, val);
                    }
                });
            }
            for (ClzTag tag : tags) {
                if (!"VLifeApi".equals(tag.getSuperName())) continue;
                for (File path : files) {
                    if (!path.getName().equals(tag.getEntityName() + ".java")) continue;
                    CommentParser.parserApi(path, tag);
                }
            }
            String filePath = this.project.getBasedir() + "/src/main/resources/";
            filePath = filePath + "/title.json";
            String data = JsonUtil.toPrettyJson(tags);
            FileUtil.nioWriteFile(data, filePath);
        } else {
            modelReadCheck.getLogger().error("\u6a21\u578b\u4fe1\u606f\u8bfb\u53d6\u5b58\u5728\u9519\u8bef,title\u4e0d\u80fd\u751f\u6210");
        }
    }
}

