/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins.constant.comment;

import cn.wwwlike.plugins.utils.CommentUtils;
import cn.wwwlike.vlife.objship.dto.BeanDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.read.ModelReadCheck;
import cn.wwwlike.vlife.objship.read.tag.ApiTag;
import cn.wwwlike.vlife.objship.read.tag.ClzTag;
import cn.wwwlike.vlife.objship.read.tag.FieldTag;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CommentParser {
    private static String clzStrToFilePath(String clzStr) {
        String path = clzStr.replace(".", "/");
        return "src/main/java/" + path + ".java";
    }

    public static ClzTag parser(Class clz, ModelReadCheck modelReadCheck) {
        return CommentParser.parserField(clz.getName(), modelReadCheck);
    }

    public static ClzTag parserField(String clzStr, ModelReadCheck modelReadCheck) {
        String FILE_PATH = CommentParser.clzStrToFilePath(clzStr);
        return CommentParser.parserField(new File(FILE_PATH), modelReadCheck);
    }

    public static ClzTag parserField(File file, ModelReadCheck modelReadCheck) {
        ClzTag clzTag = new ClzTag();
        clzTag.setEntityName(file.getName().replace(".java", ""));
        try {
            BeanDto beanDto;
            CompilationUnit cu = (CompilationUnit)new JavaParser().parse(file).getResult().get();
            TypeDeclaration typeDeclaration = (TypeDeclaration)cu.getTypes().get(0);
            if (((ClassOrInterfaceDeclaration)typeDeclaration).getExtendedTypes() != null && ((ClassOrInterfaceDeclaration)typeDeclaration).getExtendedTypes().size() > 0) {
                clzTag.setSuperName(((ClassOrInterfaceType)((ClassOrInterfaceDeclaration)typeDeclaration).getExtendedTypes().get(0)).getName().asString());
                if (((ClassOrInterfaceType)((ClassOrInterfaceDeclaration)typeDeclaration).getExtendedTypes().get(0)).getTypeArguments().isPresent()) {
                    clzTag.setTypeName(((Type)((NodeList)((ClassOrInterfaceType)((ClassOrInterfaceDeclaration)typeDeclaration).getExtendedTypes().get(0)).getTypeArguments().get()).get(0)).asString());
                }
            } else if (((ClassOrInterfaceDeclaration)typeDeclaration).getImplementedTypes() != null && ((ClassOrInterfaceDeclaration)typeDeclaration).getImplementedTypes().size() > 0) {
                clzTag.setSuperName(((ClassOrInterfaceType)((ClassOrInterfaceDeclaration)typeDeclaration).getImplementedTypes().get(0)).getName().asString());
                if (((ClassOrInterfaceType)((ClassOrInterfaceDeclaration)typeDeclaration).getImplementedTypes().get(0)).getTypeArguments().isPresent()) {
                    clzTag.setTypeName(((Type)((NodeList)((ClassOrInterfaceType)((ClassOrInterfaceDeclaration)typeDeclaration).getImplementedTypes().get(0)).getTypeArguments().get()).get(0)).asString());
                }
            }
            if ((beanDto = modelReadCheck.find(StringUtils.uncapitalize((String)clzTag.getEntityName()))) == null && !"VLifeApi".equals(clzTag.getSuperName())) {
                return null;
            }
            if (typeDeclaration.getComment().isPresent()) {
                String commentText = CommentUtils.parseCommentText(((Comment)typeDeclaration.getComment().get()).getContent());
                commentText = commentText.split("\n")[0].split("\r")[0];
                clzTag.setTitle(commentText);
            }
            NodeList list = typeDeclaration.getMembers();
            FieldTag fieldTag = null;
            for (Object o : list) {
                if (!(o instanceof FieldDeclaration)) continue;
                fieldTag = new FieldTag();
                fieldTag.setFieldName(((VariableDeclarator)((FieldDeclaration)o).getVariables().get(0)).toString());
                if (fieldTag.getFieldName().equals("id")) {
                    fieldTag.setExtendsField(Boolean.valueOf(true));
                }
                if (((FieldDeclaration)o).getComment().isPresent()) {
                    String comment = ((Comment)((FieldDeclaration)o).getComment().get()).getContent();
                    fieldTag.setTitle(CommentUtils.parseCommentText(comment).split("\n")[0].split("\r")[0]);
                } else if (beanDto != null) {
                    List fields = beanDto.getFields();
                    for (FieldDto fieldDto : fields) {
                        if (!fieldDto.getFieldName().equals(fieldTag.getFieldName())) continue;
                        fieldTag.setTitle(fieldDto.getTitle());
                    }
                }
                fieldTag.setFieldType(((FieldDeclaration)o).getElementType().asString());
                clzTag.getTags().put(fieldTag.getFieldName(), fieldTag);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clzTag;
    }

    public static ClzTag parserApi(File file, ClzTag tag) {
        CompilationUnit cu = null;
        try {
            cu = (CompilationUnit)new JavaParser().parse(file).getResult().get();
            TypeDeclaration typeDeclaration = (TypeDeclaration)cu.getTypes().get(0);
            NodeList annos = typeDeclaration.getAnnotations();
            if (annos != null && annos.size() > 0) {
                for (AnnotationExpr anno : annos) {
                    if (!anno.getName().asString().equals("RequestMapping")) continue;
                    tag.setPath(((StringLiteralExpr)anno.getChildNodes().get(1)).getValue());
                    break;
                }
            }
            NodeList list = typeDeclaration.getMembers();
            List methodDeclarations = typeDeclaration.getMembers().stream().filter(t -> t instanceof MethodDeclaration).collect(Collectors.toList());
            ApiTag apiTag = null;
            for (MethodDeclaration method : methodDeclarations) {
                apiTag = new ApiTag();
                apiTag.setTitle(method.getComment().isPresent() ? ((Comment)method.getComment().get()).getContent() : "");
                apiTag.setMethodName(method.getNameAsString());
                apiTag.setReturnClz(method.getTypeAsString());
                apiTag.setPath(((StringLiteralExpr)method.getAnnotation(0).getChildNodes().get(1)).getValue());
                apiTag.setMethodType(((Node)method.getAnnotation(0).getChildNodes().get(0)).toString());
                if (method.getParameters().size() > 0) {
                    apiTag.setParam(method.getParameter(0).getNameAsString());
                    apiTag.setParamWrapper(method.getParameter(0).getTypeAsString());
                }
                tag.getApiTagList().add(apiTag);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tag;
    }
}

