/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins.generator;

import cn.wwwlike.plugins.utils.FileUtil;
import cn.wwwlike.vlife.base.IPage;
import cn.wwwlike.vlife.bean.PageVo;
import cn.wwwlike.vlife.core.VLifeApi;
import cn.wwwlike.vlife.objship.dto.BeanDto;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.ReqDto;
import cn.wwwlike.vlife.objship.dto.SaveDto;
import cn.wwwlike.vlife.objship.dto.VoDto;
import cn.wwwlike.vlife.query.req.PageQuery;
import cn.wwwlike.vlife.query.req.VlifeQuery;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public class GeneratorApi {
    public void apiGenerator(EntityDto itemDto, List<VoDto> vos, List<ReqDto> reqs, List<SaveDto> saves) {
        List dtos;
        Class item = itemDto.getClz();
        List voDtos = vos.stream().filter(vo -> vo.getEntityClz() == item).collect(Collectors.toList());
        List<ReqDto> pageReqDtos = reqs.stream().filter(req -> req.getEntityClz() == item && PageQuery.class.isAssignableFrom(req.getClz())).collect(Collectors.toList());
        List saveDtos = saves.stream().filter(save -> save.getEntityClz() == item).collect(Collectors.toList());
        String packageName = item.getPackage().getName();
        int index = packageName.lastIndexOf("entity");
        String servicePackageName = packageName.substring(0, index) + "service";
        String apiPackageName = packageName.substring(0, index) + "api";
        ClassName superClazz = ClassName.get(VLifeApi.class);
        TypeName itemName = TypeName.get((Type)item);
        ClassName serviceName = ClassName.get((String)servicePackageName, (String)(item.getSimpleName() + "Service"), (String[])new String[0]);
        ParameterizedTypeName superClzAndGenic = ParameterizedTypeName.get((ClassName)superClazz, (TypeName[])new TypeName[]{itemName, serviceName});
        AnnotationSpec.Builder anBuilder = AnnotationSpec.builder(RequestMapping.class).addMember("value", "\"/" + StringUtils.uncapitalize((String)item.getSimpleName()) + "\"", new Object[0]);
        CodeBlock.Builder classComment = CodeBlock.builder();
        classComment.addStatement(itemDto.getTitle() + "\u63a5\u53e3", new Object[0]);
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        voDtos.stream().filter(reqDto -> reqDto.getType().indexOf("Page") != -1 || reqDto.getType().indexOf("page") != -1).forEach(dto -> methodSpecs.add(this.page((VoDto)dto, pageReqDtos)));
        if (methodSpecs.size() == 0) {
            methodSpecs.add(this.page(itemDto, pageReqDtos));
        }
        if ((dtos = voDtos.stream().filter(reqDto -> reqDto.getType().indexOf("Detail") != -1 || reqDto.getType().indexOf("detail") != -1).collect(Collectors.toList())).size() > 0) {
            dtos.stream().forEach(dto -> methodSpecs.add(this.detail((VoDto)dto)));
        } else {
            methodSpecs.add(this.detail(itemDto));
        }
        List listReqDtos = reqs.stream().filter(req -> req.getEntityClz() == item && VlifeQuery.class.isAssignableFrom(req.getClz())).collect(Collectors.toList());
        voDtos.stream().filter(voDto -> voDto.getType().indexOf("List") != -1).forEach(dto -> methodSpecs.add(this.list((VoDto)dto, listReqDtos)));
        if (saveDtos == null || saveDtos.size() == 0) {
            methodSpecs.add(this.save(itemDto));
        } else {
            saveDtos.stream().forEach(saveDto -> methodSpecs.add(this.save((SaveDto)saveDto)));
        }
        methodSpecs.add(this.delete(itemDto));
        TypeSpec apiClazz = TypeSpec.classBuilder((String)(item.getSimpleName() + "Api")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(classComment.build()).addAnnotation(RestController.class).addAnnotation(anBuilder.build()).superclass((TypeName)superClzAndGenic).addMethods(methodSpecs).build();
        JavaFile javaFile = JavaFile.builder((String)apiPackageName, (TypeSpec)apiClazz).build();
        try {
            FileUtil.generateJavaFIle(javaFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MethodSpec page(VoDto result, List<ReqDto> req) {
        String methodName = this.calcMethodName((BeanDto)result, result.getEntityClz(), "Page");
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder methodComment = CodeBlock.builder();
        methodComment.addStatement(result.getTitle() + "\u5206\u9875\u67e5\u8be2", new Object[0]);
        methodComment.addStatement("@param req \u67e5\u8be2\u6761\u4ef6", new Object[0]);
        methodComment.addStatement("@return", new Object[0]);
        AnnotationSpec.Builder methodAnnotation = AnnotationSpec.builder(GetMapping.class);
        methodAnnotation.addMember("value", "\"" + this.path(methodName) + "\"", new Object[0]);
        TypeName returnTypeName = TypeName.get((Type)result.getClz());
        ParameterizedTypeName returnGenic = ParameterizedTypeName.get((ClassName)ClassName.get(PageVo.class), (TypeName[])new TypeName[]{returnTypeName});
        if (req.size() > 0) {
            Class queryReq = req.get(0).getClz();
            ParameterSpec.Builder inSpec = ParameterSpec.builder((Type)queryReq, (String)"req", (Modifier[])new Modifier[0]);
            methodSpec.addParameter(inSpec.build());
        } else {
            TypeName methodReq = TypeName.get((Type)result.getEntityClz());
            ParameterizedTypeName reqGenic = ParameterizedTypeName.get((ClassName)ClassName.get(PageQuery.class), (TypeName[])new TypeName[]{methodReq});
            methodSpec.addStatement("$T req= new $T(" + result.getEntityClz().getSimpleName() + ".class)", new Object[]{reqGenic, reqGenic});
        }
        methodSpec.addStatement("return service.queryPage(" + result.getClz().getSimpleName() + ".class,req)", new Object[0]);
        methodSpec.returns((TypeName)returnGenic).addJavadoc(methodComment.build()).addAnnotation(methodAnnotation.build());
        return methodSpec.build();
    }

    public MethodSpec page(EntityDto result, List<ReqDto> req) {
        String methodName = "page";
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder methodComment = CodeBlock.builder();
        methodComment.addStatement(result.getTitle() + "\u5206\u9875\u67e5\u8be2", new Object[0]);
        if (req != null && req.size() > 0) {
            methodComment.addStatement("@param req \u67e5\u8be2\u6761\u4ef6", new Object[0]);
        }
        methodComment.addStatement("@return", new Object[0]);
        AnnotationSpec.Builder methodAnnotation = AnnotationSpec.builder(GetMapping.class);
        methodAnnotation.addMember("value", "\"/" + methodName + "\"", new Object[0]);
        TypeName returnTypeName = TypeName.get((Type)result.getClz());
        ParameterizedTypeName returnGenic = ParameterizedTypeName.get((ClassName)ClassName.get(PageVo.class), (TypeName[])new TypeName[]{returnTypeName});
        if (req.size() > 0) {
            Class queryReq = req.get(0).getClz();
            ParameterSpec.Builder inSpec = ParameterSpec.builder((Type)queryReq, (String)"req", (Modifier[])new Modifier[0]);
            methodSpec.addParameter(inSpec.build());
        } else {
            TypeName methodReq = TypeName.get((Type)result.getClz());
            ParameterizedTypeName reqGenic = ParameterizedTypeName.get((ClassName)ClassName.get(PageQuery.class), (TypeName[])new TypeName[]{methodReq});
            methodSpec.addStatement("$T req= new $T(" + result.getClz().getSimpleName() + ".class)", new Object[]{reqGenic, reqGenic});
        }
        methodSpec.addStatement("return service.findPage(req)", new Object[0]);
        methodSpec.returns((TypeName)returnGenic).addJavadoc(methodComment.build()).addAnnotation(methodAnnotation.build());
        return methodSpec.build();
    }

    public MethodSpec detail(VoDto itemDto) {
        String methodName = this.calcMethodName((BeanDto)itemDto, itemDto.getEntityClz(), "Detail");
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder methodComment = CodeBlock.builder();
        methodComment.addStatement(itemDto.getTitle() + "\u660e\u7ec6\u67e5\u8be2", new Object[0]);
        methodComment.addStatement("@param id \u67e5\u8be2id", new Object[0]);
        methodComment.addStatement("@return", new Object[0]);
        AnnotationSpec.Builder methodAnnotation = AnnotationSpec.builder(GetMapping.class);
        methodAnnotation.addMember("value", "\"" + this.path(methodName) + "/{id}\"", new Object[0]);
        TypeName returnType = TypeName.get((Type)itemDto.getClz());
        methodSpec.addStatement("return service.queryOne(" + itemDto.getClz().getSimpleName() + ".class,id)", new Object[0]);
        AnnotationSpec.Builder pathAnnotation = AnnotationSpec.builder(PathVariable.class);
        ParameterSpec.Builder inSpec = ParameterSpec.builder(String.class, (String)"id", (Modifier[])new Modifier[0]);
        inSpec.addAnnotation(pathAnnotation.build());
        methodSpec.returns(returnType).addParameter(inSpec.build()).addJavadoc(methodComment.build()).addAnnotation(methodAnnotation.build());
        return methodSpec.build();
    }

    public MethodSpec detail(EntityDto itemDto) {
        String methodName = "detail";
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder methodComment = CodeBlock.builder();
        methodComment.addStatement(itemDto.getTitle() + "\u660e\u7ec6\u67e5\u8be2", new Object[0]);
        methodComment.addStatement("@param id \u67e5\u8be2id", new Object[0]);
        methodComment.addStatement("@return", new Object[0]);
        AnnotationSpec.Builder methodAnnotation = AnnotationSpec.builder(GetMapping.class);
        methodAnnotation.addMember("value", "\"" + this.path(methodName) + "/{id}\"", new Object[0]);
        TypeName returnType = TypeName.get((Type)itemDto.getClz());
        methodSpec.addStatement("return service.findOne(id)", new Object[0]);
        AnnotationSpec.Builder pathAnnotation = AnnotationSpec.builder(PathVariable.class);
        ParameterSpec.Builder inSpec = ParameterSpec.builder(String.class, (String)"id", (Modifier[])new Modifier[0]);
        inSpec.addAnnotation(pathAnnotation.build());
        methodSpec.returns(returnType).addParameter(inSpec.build()).addJavadoc(methodComment.build()).addAnnotation(methodAnnotation.build());
        return methodSpec.build();
    }

    public MethodSpec report(EntityDto itemDto) {
        String methodName = "detail";
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder methodComment = CodeBlock.builder();
        methodComment.addStatement(itemDto.getTitle() + "\u660e\u7ec6\u67e5\u8be2", new Object[0]);
        methodComment.addStatement("@param id \u67e5\u8be2id", new Object[0]);
        methodComment.addStatement("@return", new Object[0]);
        AnnotationSpec.Builder methodAnnotation = AnnotationSpec.builder(GetMapping.class);
        methodAnnotation.addMember("value", "\"" + this.path(methodName) + "/{id}\"", new Object[0]);
        TypeName returnType = TypeName.get((Type)itemDto.getClz());
        methodSpec.addStatement("return service.findOne(id)", new Object[0]);
        AnnotationSpec.Builder pathAnnotation = AnnotationSpec.builder(PathVariable.class);
        ParameterSpec.Builder inSpec = ParameterSpec.builder(String.class, (String)"id", (Modifier[])new Modifier[0]);
        inSpec.addAnnotation(pathAnnotation.build());
        methodSpec.returns(returnType).addParameter(inSpec.build()).addJavadoc(methodComment.build()).addAnnotation(methodAnnotation.build());
        return methodSpec.build();
    }

    public MethodSpec list(VoDto result, List<ReqDto> reqs) {
        List notPageReq = reqs.stream().filter(req -> !IPage.class.isAssignableFrom(req.getClz())).collect(Collectors.toList());
        String methodName = this.calcMethodName((BeanDto)result, result.getEntityClz(), "List");
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder methodComment = CodeBlock.builder();
        methodComment.addStatement(result.getTitle() + "\u5217\u8868\u67e5\u8be2", new Object[0]);
        if (notPageReq != null && notPageReq.size() > 0) {
            methodComment.addStatement("@param req \u67e5\u8be2\u6761\u4ef6", new Object[0]);
        }
        methodComment.addStatement("@return", new Object[0]);
        AnnotationSpec.Builder methodAnnotation = AnnotationSpec.builder(GetMapping.class);
        methodAnnotation.addMember("value", "\"" + this.path(methodName) + "\"", new Object[0]);
        TypeName returnTypeName = TypeName.get((Type)result.getClz());
        ParameterizedTypeName returnGenic = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{returnTypeName});
        if (notPageReq.size() > 0) {
            Class queryReq = ((ReqDto)notPageReq.get(0)).getClz();
            ParameterSpec.Builder inSpec = ParameterSpec.builder((Type)queryReq, (String)"req", (Modifier[])new Modifier[0]);
            methodSpec.addParameter(inSpec.build());
        } else {
            TypeName methodReq = TypeName.get((Type)result.getEntityClz());
            ParameterizedTypeName reqGenic = ParameterizedTypeName.get((ClassName)ClassName.get(PageQuery.class), (TypeName[])new TypeName[]{methodReq});
            methodSpec.addStatement("$T req= new $T()", new Object[]{reqGenic, reqGenic});
        }
        methodSpec.addStatement("return service.query(" + result.getClz().getSimpleName() + ".class,req)", new Object[0]);
        methodSpec.returns((TypeName)returnGenic).addJavadoc(methodComment.build()).addAnnotation(methodAnnotation.build());
        return methodSpec.build();
    }

    public MethodSpec save(SaveDto saveDto) {
        String methodName = this.calcMethodName((BeanDto)saveDto, saveDto.getEntityClz(), "Save");
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder methodComment = CodeBlock.builder();
        methodComment.addStatement(saveDto.getTitle() + "\u4fdd\u5b58", new Object[0]);
        methodComment.addStatement("@param dto " + saveDto.getTitle(), new Object[0]);
        methodComment.addStatement("@return", new Object[0]);
        AnnotationSpec.Builder methodAnnotation = AnnotationSpec.builder(PostMapping.class);
        methodAnnotation.addMember("value", "\"" + this.path(methodName) + "\"", new Object[0]);
        TypeName returnTypeName = TypeName.get((Type)saveDto.getClz());
        ParameterSpec.Builder inSpec = ParameterSpec.builder((TypeName)returnTypeName, (String)"dto", (Modifier[])new Modifier[0]);
        AnnotationSpec.Builder requestBody = AnnotationSpec.builder(RequestBody.class);
        inSpec.addAnnotation(requestBody.build());
        methodSpec.addStatement("return service.save(dto)", new Object[0]).returns(returnTypeName).addParameter(inSpec.build()).addJavadoc(methodComment.build()).addAnnotation(methodAnnotation.build());
        return methodSpec.build();
    }

    public MethodSpec save(EntityDto itemDto) {
        String methodName = "save";
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder methodComment = CodeBlock.builder();
        methodComment.addStatement(itemDto.getTitle() + "\u4fdd\u5b58", new Object[0]);
        methodComment.addStatement("@param entity " + itemDto.getTitle(), new Object[0]);
        methodComment.addStatement("@return", new Object[0]);
        AnnotationSpec.Builder methodAnnotation = AnnotationSpec.builder(PostMapping.class);
        methodAnnotation.addMember("value", "\"/save\"", new Object[0]);
        TypeName returnTypeName = TypeName.get((Type)itemDto.getClz());
        ParameterSpec.Builder inSpec = ParameterSpec.builder((TypeName)returnTypeName, (String)"entity", (Modifier[])new Modifier[0]);
        AnnotationSpec.Builder requestBody = AnnotationSpec.builder(RequestBody.class);
        inSpec.addAnnotation(requestBody.build());
        methodSpec.addStatement("return service.save(entity)", new Object[0]);
        methodSpec.addParameter(inSpec.build()).returns(returnTypeName).addJavadoc(methodComment.build()).addAnnotation(methodAnnotation.build());
        return methodSpec.build();
    }

    public MethodSpec delete(EntityDto itemDto) {
        String methodName = "delete";
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder methodComment = CodeBlock.builder();
        methodComment.addStatement(itemDto.getTitle() + "\u5220\u9664", new Object[0]);
        methodComment.addStatement("@param id \u4e3b\u952eid", new Object[0]);
        methodComment.addStatement("@return", new Object[0]);
        AnnotationSpec.Builder methodAnnotation = AnnotationSpec.builder(DeleteMapping.class);
        methodAnnotation.addMember("value", "\"/delete/{id}\"", new Object[0]);
        TypeName returnType = TypeName.get(Long.class);
        methodSpec.addStatement("return service.remove(id)", new Object[0]);
        AnnotationSpec.Builder pathAnnotation = AnnotationSpec.builder(PathVariable.class);
        ParameterSpec.Builder inSpec = ParameterSpec.builder(String.class, (String)"id", (Modifier[])new Modifier[0]);
        inSpec.addAnnotation(pathAnnotation.build());
        methodSpec.returns(returnType).addParameter(inSpec.build()).addJavadoc(methodComment.build()).addAnnotation(methodAnnotation.build());
        return methodSpec.build();
    }

    private String calcMethodName(BeanDto dto, Class itemClz, String type) {
        String beanClzName = dto.getClz().getSimpleName();
        beanClzName = beanClzName.replaceFirst("Vo", "");
        beanClzName = beanClzName.replaceFirst("Dto", "");
        if ((beanClzName = beanClzName.replaceFirst(itemClz.getSimpleName(), "")).endsWith(type) || beanClzName.endsWith(StringUtils.uncapitalize((String)type))) {
            beanClzName = beanClzName.substring(0, beanClzName.length() - type.length());
        }
        return StringUtils.uncapitalize((String)type) + beanClzName;
    }

    private String path(String methodName) {
        if (methodName.startsWith("page") && !methodName.equals("page")) {
            return "/page/" + StringUtils.uncapitalize((String)methodName.substring(4));
        }
        if (methodName.startsWith("list") && !methodName.equals("list")) {
            return "/list/" + StringUtils.uncapitalize((String)methodName.substring(4));
        }
        if (methodName.startsWith("detail") && !methodName.equals("detail")) {
            return "/detail/" + StringUtils.uncapitalize((String)methodName.substring(6));
        }
        if (methodName.startsWith("save") && !methodName.equals("save")) {
            return "/save/" + StringUtils.uncapitalize((String)methodName.substring(4));
        }
        return "/" + methodName;
    }
}

