/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins.generator;

import cn.wwwlike.base.common.RequestTypeEnum;
import cn.wwwlike.plugins.generator.api.ApiMethodCreate;
import cn.wwwlike.plugins.generator.api.MethodTypeEnum;
import cn.wwwlike.vlife.annotation.VClazz;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.base.VoBean;
import cn.wwwlike.vlife.core.VLifeApi;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.ReqDto;
import cn.wwwlike.vlife.objship.dto.SaveDto;
import cn.wwwlike.vlife.objship.dto.VoDto;
import cn.wwwlike.vlife.query.req.PageQuery;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public class GeneratorAutoApi {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<? extends Item> item = null;
    private EntityDto itemDto = null;

    public JavaFile apiGenerator(EntityDto itemDto, List<VoDto> vos, List<ReqDto> reqs, List<SaveDto> saves) {
        this.itemDto = itemDto;
        this.item = itemDto.getClz();
        List<ReqDto> reqDtos = reqs.stream().filter(req -> req.getEntityClz() == this.item).collect(Collectors.toList());
        List<VoDto> voDtos = vos.stream().filter(vo -> vo.getEntityClz() == this.item).collect(Collectors.toList());
        List<SaveDto> saveDtos = saves.stream().filter(save -> save.getEntityClz() == this.item).collect(Collectors.toList());
        String packageName = this.item.getPackage().getName();
        int index = packageName.lastIndexOf("entity");
        String servicePackageName = packageName.substring(0, index) + "service";
        String apiPackageName = packageName.substring(0, index) + "api";
        ClassName superClazz = ClassName.get(VLifeApi.class);
        TypeName itemName = TypeName.get(this.item);
        ClassName serviceName = ClassName.get((String)servicePackageName, (String)(this.item.getSimpleName() + "Service"), (String[])new String[0]);
        ParameterizedTypeName superClzAndGenic = ParameterizedTypeName.get((ClassName)superClazz, (TypeName[])new TypeName[]{itemName, serviceName});
        AnnotationSpec.Builder anBuilder = AnnotationSpec.builder(RequestMapping.class).addMember("value", "\"/" + StringUtils.uncapitalize((String)this.item.getSimpleName()) + "\"", new Object[0]);
        CodeBlock.Builder classComment = CodeBlock.builder();
        Class masterVo = this.compMasterVo(voDtos, this.item.getSimpleName());
        classComment.addStatement(itemDto.getTitle() + "\u63a5\u53e3", new Object[0]);
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        methodSpecs.addAll(this.createQueryMethod(reqDtos, voDtos, masterVo));
        methodSpecs.addAll(this.createSaveMethod(saveDtos));
        methodSpecs.addAll(this.createDetailMethod(voDtos, this.item, masterVo));
        methodSpecs.add(ApiMethodCreate.createMethod(MethodTypeEnum.remove, this.item));
        TypeSpec apiClazz = TypeSpec.classBuilder((String)(this.item.getSimpleName() + "Api")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(classComment.build()).addAnnotation(RestController.class).addAnnotation(anBuilder.build()).superclass((TypeName)superClzAndGenic).addMethods(methodSpecs).build();
        JavaFile javaFile = JavaFile.builder((String)apiPackageName, (TypeSpec)apiClazz).build();
        return javaFile;
    }

    private List<MethodSpec> createQueryMethod(List<ReqDto> reqDtos, List<VoDto> voDtos, Class masterVo) {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        reqDtos.stream().forEach(req -> {
            VClazz vClazz = req.getClz().getAnnotation(VClazz.class);
            MethodTypeEnum method = null;
            boolean pageQuery = PageQuery.class.isAssignableFrom(req.getClz());
            if (vClazz == null || vClazz.requestType() == RequestTypeEnum.NULL) {
                method = pageQuery ? MethodTypeEnum.page : MethodTypeEnum.list;
            } else {
                switch (vClazz.requestType()) {
                    case POST_ONE: {
                        method = MethodTypeEnum.post_one;
                        break;
                    }
                    case GET_ONE: {
                        method = MethodTypeEnum.get_one;
                        break;
                    }
                    default: {
                        method = pageQuery ? MethodTypeEnum.page : MethodTypeEnum.list;
                    }
                }
            }
            Class voClz = this.compVoReturnClz((ReqDto)req, voDtos, masterVo);
            methodSpecs.add(ApiMethodCreate.createMethod(method, this.item, req.getClz(), voClz));
        });
        return methodSpecs;
    }

    private List<MethodSpec> createSaveMethod(List<SaveDto> saveDtos) {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        saveDtos.forEach(dto -> {
            VClazz vClazz = dto.getClz().getAnnotation(VClazz.class);
            Object method = null;
            if (vClazz == null || vClazz.requestType() != RequestTypeEnum.SAVE_CustomName) {
                methodSpecs.add(ApiMethodCreate.createMethod(MethodTypeEnum.save, this.item, dto.clz, dto.clz));
            } else {
                methodSpecs.add(ApiMethodCreate.createMethod(MethodTypeEnum.commit, this.item, dto.clz, dto.clz));
            }
        });
        if (methodSpecs.size() == 0) {
            methodSpecs.add(ApiMethodCreate.createMethod(MethodTypeEnum.save, this.item, this.item, this.item));
        }
        return methodSpecs;
    }

    private List<MethodSpec> createDetailMethod(List<VoDto> voDtos, Class<? extends Item> item, Class masterVo) {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        voDtos.stream().filter(voDto -> StringUtils.indexOfIgnoreCase((CharSequence)voDto.getType(), (CharSequence)"detail") != -1).forEach(dto -> methodSpecs.add(ApiMethodCreate.createMethod(MethodTypeEnum.detail, item, String.class, dto.clz)));
        if (methodSpecs.size() == 0 && masterVo != null) {
            methodSpecs.add(ApiMethodCreate.createMethod(MethodTypeEnum.detail, item, String.class, masterVo));
        }
        if (methodSpecs.size() == 0) {
            methodSpecs.add(ApiMethodCreate.createMethod(MethodTypeEnum.detail, item, String.class, item));
        }
        return methodSpecs;
    }

    public Class compMasterVo(List<VoDto> voDtos, String itemName) {
        for (VoDto vo : voDtos) {
            String voName = vo.getClz().getSimpleName();
            if (!voName.equalsIgnoreCase(itemName + "Vo")) continue;
            return vo.getClz();
        }
        return null;
    }

    private Class compVoReturnClz(ReqDto req, List<VoDto> voDtos, Class masterVo) {
        if (voDtos == null || voDtos.size() == 0) {
            return this.item;
        }
        VClazz v = req.getClz().getAnnotation(VClazz.class);
        if (v != null && v.returnType() != Object.class) {
            Class returnType = v.returnType();
            if (Item.class.isAssignableFrom(returnType) || VoBean.class.isAssignableFrom(returnType)) {
                return returnType;
            }
            this.logger.error(req.getClz().getSimpleName() + "  VClazz[returnType] is setting error!");
        }
        if (req != null) {
            String itemName = this.item.getSimpleName();
            String key = ApiMethodCreate.filterKey(req.getClz().getSimpleName(), itemName);
            for (VoDto vo : voDtos) {
                String voName = vo.getClz().getSimpleName();
                String voKey = ApiMethodCreate.filterKey(voName, itemName);
                if (!StringUtils.isNotEmpty((CharSequence)key) || !key.equalsIgnoreCase(voKey)) continue;
                return vo.getClz();
            }
        }
        if (masterVo != null) {
            return masterVo;
        }
        return this.item;
    }
}

