/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins.generator;

import cn.wwwlike.vlife.base.BaseRequest;
import cn.wwwlike.vlife.base.IPage;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.base.VoBean;
import cn.wwwlike.vlife.bean.PageVo;
import cn.wwwlike.vlife.core.VLifeApi;
import cn.wwwlike.vlife.core.VLifeService;
import cn.wwwlike.vlife.core.dsl.DslDao;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.ReqDto;
import cn.wwwlike.vlife.objship.dto.VoDto;
import cn.wwwlike.vlife.utils.GenericsUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public class GeneratorClzPath {
    private static void generateToCurrentAndroidStudioModule(JavaFile javaFile) throws IOException {
        String targetDirectory = "src/main/java";
        File dir = new File(targetDirectory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        javaFile.writeTo(dir);
    }

    public void generator(List<EntityDto> entitys, List<VoDto> vos, List<ReqDto> res) {
        List<Class<? extends Item>> entityList = entitys.stream().map(entityDto -> entityDto.getClz()).collect(Collectors.toList());
        List<Class<? extends VoBean>> voList = vos.stream().map(voDto -> voDto.getClz()).collect(Collectors.toList());
        List<Class<? extends BaseRequest>> reqList = res.stream().map(resDto -> resDto.getClz()).collect(Collectors.toList());
        this.daoGenerator(entityList);
        this.serviceGenerator(entityList);
        this.apiGenerator(entityList, voList, reqList);
    }

    public void apiGenerator(List<Class<? extends Item>> items, List<Class<? extends VoBean>> vos, List<Class<? extends BaseRequest>> reqs) {
        for (Class<? extends Item> item : items) {
            List item_vos = vos.stream().filter(vo -> GenericsUtils.getGenericType((Class)vo) == item || GenericsUtils.getSuperClassGenricType((Class)vo) == item).collect(Collectors.toList());
            List item_reqs = reqs.stream().filter(req -> GenericsUtils.getGenericType((Class)req) == item || GenericsUtils.getSuperClassGenricType((Class)req) == item).collect(Collectors.toList());
            if (item_vos.size() == 0) {
                item_vos.add(item);
            }
            String packageName = item.getPackage().getName();
            int index = packageName.lastIndexOf("entity");
            String servicePackageName = packageName.substring(0, index) + "service";
            String apiPackageName = packageName.substring(0, index) + "api";
            try {
                ClassName superClazz = ClassName.get(VLifeApi.class);
                TypeName itemName = TypeName.get(item);
                ClassName serviceName = ClassName.get((String)servicePackageName, (String)(item.getSimpleName() + "Service"), (String[])new String[0]);
                ParameterizedTypeName clzAndGenic = ParameterizedTypeName.get((ClassName)superClazz, (TypeName[])new TypeName[]{itemName, serviceName});
                AnnotationSpec.Builder anBuilder = AnnotationSpec.builder(RequestMapping.class).addMember("value", "\"/" + StringUtils.uncapitalize((String)item.getSimpleName()) + "\"", new Object[0]);
                ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
                for (Class vo2 : item_vos) {
                    Class queryReq;
                    String methodPath = vo2.getSimpleName();
                    int i = methodPath.indexOf(item.getSimpleName());
                    if (i != -1) {
                        methodPath = methodPath.substring(item.getSimpleName().length());
                    }
                    MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)vo2.getSimpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
                    TypeName rrName = TypeName.get((Type)vo2);
                    ParameterizedTypeName returnGenic = null;
                    ParameterSpec.Builder inSpec = null;
                    AnnotationSpec.Builder methodAnnotation = AnnotationSpec.builder(GetMapping.class);
                    if (vo2.getSimpleName().endsWith("List")) {
                        methodAnnotation.addMember("value", "\"/" + StringUtils.uncapitalize((String)methodPath) + "\"", new Object[0]);
                        returnGenic = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{rrName});
                        queryReq = null;
                        Iterator iterator = item_reqs.iterator();
                        while (iterator.hasNext()) {
                            Class req2;
                            queryReq = req2 = (Class)iterator.next();
                            if (IPage.class.isAssignableFrom(req2)) continue;
                            break;
                        }
                        if (queryReq != null) {
                            inSpec = ParameterSpec.builder((Type)queryReq, (String)"req", (Modifier[])new Modifier[0]);
                        }
                        methodSpec.addStatement("return service.query($T.class,req)", new Object[]{vo2});
                    } else if (vo2.getSimpleName().endsWith("Page")) {
                        methodAnnotation.addMember("value", "\"/" + StringUtils.uncapitalize((String)methodPath) + "\"", new Object[0]);
                        returnGenic = ParameterizedTypeName.get((ClassName)ClassName.get(PageVo.class), (TypeName[])new TypeName[]{rrName});
                        queryReq = null;
                        for (Class req2 : item_reqs) {
                            if (!IPage.class.isAssignableFrom(req2)) continue;
                            queryReq = req2;
                            break;
                        }
                        if (queryReq != null) {
                            inSpec = ParameterSpec.builder((Type)queryReq, (String)"req", (Modifier[])new Modifier[0]);
                        }
                        methodSpec.addStatement("return null", new Object[0]);
                    } else {
                        methodAnnotation.addMember("value", "\"/" + StringUtils.uncapitalize((String)methodPath) + "/{id}\"", new Object[0]);
                        inSpec = ParameterSpec.builder((TypeName)TypeName.get(String.class), (String)"id", (Modifier[])new Modifier[0]);
                        inSpec.addAnnotation(PathVariable.class);
                        methodSpec.addStatement("return null", new Object[0]);
                    }
                    methodSpec.returns((TypeName)(returnGenic != null ? returnGenic : rrName)).addAnnotation(methodAnnotation.build());
                    if (inSpec != null) {
                        methodSpec.addParameter(inSpec.build());
                    }
                    methodSpecs.add(methodSpec.build());
                }
                TypeSpec apiClazz = TypeSpec.classBuilder((String)(item.getSimpleName() + "Api")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(RestController.class).addAnnotation(anBuilder.build()).superclass((TypeName)clzAndGenic).addMethods(methodSpecs).build();
                JavaFile javaFile = JavaFile.builder((String)apiPackageName, (TypeSpec)apiClazz).build();
                GeneratorClzPath.generateToCurrentAndroidStudioModule(javaFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void serviceGenerator(List<Class<? extends Item>> items) {
        for (Class<? extends Item> item : items) {
            String packageName = item.getPackage().getName();
            int index = packageName.lastIndexOf("entity");
            String daoPackageName = packageName.substring(0, index) + "dao";
            String servicePackageName = packageName.substring(0, index) + "service";
            String daoClzName = daoPackageName + "." + item.getSimpleName() + "Dao";
            try {
                ClassName superClazz = ClassName.get(VLifeService.class);
                TypeName itemName = TypeName.get(item);
                ClassName daoName = ClassName.get((String)daoPackageName, (String)(item.getSimpleName() + "Dao"), (String[])new String[0]);
                ParameterizedTypeName clzAndGenic = ParameterizedTypeName.get((ClassName)superClazz, (TypeName[])new TypeName[]{itemName, daoName});
                TypeSpec user = TypeSpec.classBuilder((String)(item.getSimpleName() + "Service")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Service.class).superclass((TypeName)clzAndGenic).build();
                JavaFile javaFile = JavaFile.builder((String)servicePackageName, (TypeSpec)user).build();
                GeneratorClzPath.generateToCurrentAndroidStudioModule(javaFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void daoGenerator(List<Class<? extends Item>> items) {
        for (Class<? extends Item> item : items) {
            ParameterizedTypeName clzAndGenic = ParameterizedTypeName.get(DslDao.class, (Type[])new Type[]{item});
            TypeSpec user = TypeSpec.classBuilder((String)(item.getSimpleName() + "Dao")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Repository.class).superclass((TypeName)clzAndGenic).build();
            String packageName = item.getPackage().getName();
            int index = packageName.lastIndexOf("entity");
            String daoPackageName = packageName.substring(0, index) + "dao";
            JavaFile javaFile = JavaFile.builder((String)daoPackageName, (TypeSpec)user).build();
            try {
                GeneratorClzPath.generateToCurrentAndroidStudioModule(javaFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

