/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins.generator;

import cn.wwwlike.base.model.IdBean;
import cn.wwwlike.plugins.generator.GeneratorAutoApi;
import cn.wwwlike.plugins.generator.GeneratorUtils;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.core.VLifeService;
import cn.wwwlike.vlife.core.dsl.DslDao;
import cn.wwwlike.vlife.objship.dto.BeanDto;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.dto.ReqDto;
import cn.wwwlike.vlife.objship.dto.ReqVoDto;
import cn.wwwlike.vlife.objship.dto.SaveDto;
import cn.wwwlike.vlife.objship.dto.VoDto;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

public class GeneratorMaster
extends GeneratorUtils {
    List<String> error = new ArrayList<String>();

    public List<JavaFile> generator(String basePath, ClassLoader loader, List<EntityDto> entitys, List<VoDto> vos, List<ReqDto> res, List<SaveDto> saves) {
        List<Class<? extends Item>> entityList = entitys.stream().map(entityDto -> entityDto.getClz()).collect(Collectors.toList());
        List voList = vos.stream().map(voDto -> voDto.getClz()).collect(Collectors.toList());
        List reqList = res.stream().map(resDto -> resDto.getClz()).collect(Collectors.toList());
        List saveList = saves.stream().map(saveBean -> saveBean.getClz()).collect(Collectors.toList());
        ArrayList<JavaFile> waitCreateFiles = new ArrayList<JavaFile>();
        waitCreateFiles.addAll(this.apiGenerator(basePath, entitys, vos, res, saves));
        waitCreateFiles.addAll(this.daoGenerator(basePath, entityList));
        waitCreateFiles.addAll(this.serviceGenerator(basePath, entityList));
        return waitCreateFiles;
    }

    public List<JavaFile> apiGenerator(String basePath, List<EntityDto> entitys, List<VoDto> vos, List<ReqDto> reqs, List<SaveDto> saves) {
        GeneratorAutoApi generatorApi = new GeneratorAutoApi();
        ArrayList<JavaFile> files = new ArrayList<JavaFile>();
        entitys.forEach(entityDto -> {
            String packagePath = entityDto.getClz().getPackage().getName();
            if (!this.sourceClzExist(entityDto.getClz(), basePath, GeneratorUtils.CLZ_TYPE.API)) {
                files.add(generatorApi.apiGenerator((EntityDto)entityDto, vos, reqs, saves));
            }
        });
        return files;
    }

    public List<JavaFile> serviceGenerator(String basePath, List<Class<? extends Item>> items) {
        ArrayList<JavaFile> files = new ArrayList<JavaFile>();
        for (Class<? extends Item> item : items) {
            if (this.sourceClzExist(item, basePath, GeneratorUtils.CLZ_TYPE.SERVICE)) continue;
            String packageName = item.getPackage().getName();
            int index = packageName.lastIndexOf("entity");
            String daoPackageName = packageName.substring(0, index) + "dao";
            String servicePackageName = packageName.substring(0, index) + "service";
            String daoClzName = daoPackageName + "." + item.getSimpleName() + "Dao";
            ClassName superClazz = ClassName.get(VLifeService.class);
            TypeName itemName = TypeName.get(item);
            ClassName daoName = ClassName.get((String)daoPackageName, (String)(item.getSimpleName() + "Dao"), (String[])new String[0]);
            ParameterizedTypeName clzAndGenic = ParameterizedTypeName.get((ClassName)superClazz, (TypeName[])new TypeName[]{itemName, daoName});
            TypeSpec user = TypeSpec.classBuilder((String)(item.getSimpleName() + "Service")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Service.class).superclass((TypeName)clzAndGenic).build();
            files.add(JavaFile.builder((String)servicePackageName, (TypeSpec)user).build());
        }
        return files;
    }

    public List<JavaFile> daoGenerator(String basePath, List<Class<? extends Item>> items) {
        ArrayList<JavaFile> files = new ArrayList<JavaFile>();
        for (Class<? extends Item> item : items) {
            if (this.sourceClzExist(item, basePath, GeneratorUtils.CLZ_TYPE.DAO)) continue;
            ParameterizedTypeName clzAndGenic = ParameterizedTypeName.get(DslDao.class, (Type[])new Type[]{item});
            TypeSpec user = TypeSpec.classBuilder((String)(item.getSimpleName() + "Dao")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Repository.class).superclass((TypeName)clzAndGenic).build();
            String packageName = item.getPackage().getName();
            int index = packageName.lastIndexOf("entity");
            String daoPackageName = packageName.substring(0, index) + "dao";
            files.add(JavaFile.builder((String)daoPackageName, (TypeSpec)user).build());
        }
        return files;
    }

    private void check(ReqVoDto reqDto) {
        if (reqDto.getEntityClz() == null) {
            this.error.add(reqDto.getClz().getSimpleName());
        }
    }

    private void check(BeanDto table, FieldDto fieldDto) {
        String tableName = table.getClass().getSimpleName() + "__";
        if (fieldDto.getFieldType() == null || fieldDto.getEntityClz() == null) {
            this.error.add(tableName + fieldDto.getItemDto().getClz().getSimpleName() + "__" + fieldDto.getFieldName() + "\u627e\u4e0d\u5230\u5b9e\u4f53\u7c7b\u548c\u5b57\u6bb5");
            return;
        }
        if (fieldDto.getFieldType().equals("basic")) {
            if (fieldDto.getEntityFieldName() == null || fieldDto.getQueryPath() == null) {
                this.error.add(tableName + fieldDto.getItemDto().getClz().getSimpleName() + "__" + fieldDto.getFieldName() + "\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u5b57\u6bb5");
                return;
            }
        } else {
            if (fieldDto.getQueryPath() == null || fieldDto.queryPathName() == null) {
                this.error.add(tableName + fieldDto.getItemDto().getClz().getSimpleName() + "__" + fieldDto.getFieldName() + "\u7684\u67e5\u8be2\u8def\u5f84\u6ca1\u6709\u627e\u5230\uff0c\u8bf7\u5148\u68c0\u67e5\u7c7b\u578b\u8bbe\u7f6e\u662f\u5426\u51c6\u786e");
                return;
            }
            if (IdBean.class.isAssignableFrom(fieldDto.getClz()) && fieldDto.queryPathName().indexOf("_") != -1) {
                String queryName = fieldDto.queryPathName();
                int _size = queryName.split("_").length - 1;
                int __length = queryName.split("__").length - 1;
                String fieldType = fieldDto.getFieldType();
                if (_size == __length * 2) {
                    if ("list".equals(fieldType)) {
                        this.error.add(tableName + fieldDto.getItemDto().getClz().getSimpleName() + "\u7684" + fieldDto.getFieldName() + "\u5b57\u6bb5\u5e94\u8be5\u4e3aobject");
                    }
                } else if (!"list".equals(fieldType)) {
                    this.error.add(tableName + fieldDto.getItemDto().getClz().getSimpleName() + "\u7684" + fieldDto.getFieldName() + "\u5b57\u6bb5\u5e94\u8be5\u4e3alist");
                }
            }
        }
    }

    private void errInfo(List<? extends BeanDto> ... beanDtos) {
        for (List<? extends BeanDto> list : beanDtos) {
            for (BeanDto beanDto : list) {
                List list2;
                if (beanDto instanceof ReqVoDto) {
                    this.check((ReqVoDto)beanDto);
                }
                if ((list2 = beanDto.getFields()) == null) continue;
                for (FieldDto dto1 : list2) {
                    this.check(beanDto, dto1);
                }
            }
        }
    }
}

