/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins.generator;

import cn.wwwlike.plugins.generator.GeneratorUtils;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.dto.ReqDto;
import cn.wwwlike.vlife.objship.dto.VoDto;
import cn.wwwlike.vlife.objship.read.GlobalData;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class GeneratorTableDict
extends GeneratorUtils {
    public List<JavaFile> generator(List<EntityDto> entitys, List<VoDto> vos, List<ReqDto> res) {
        ArrayList<JavaFile> files = new ArrayList<JavaFile>();
        List entityList = entitys.stream().map(entityDto -> entityDto.getClz()).collect(Collectors.toList());
        List voList = vos.stream().map(voDto -> voDto.getClz()).collect(Collectors.toList());
        List reqList = res.stream().map(resDto -> resDto.getClz()).collect(Collectors.toList());
        files.addAll(this.dictGenerator(entitys));
        files.addAll(this.ClzPath(entitys));
        return files;
    }

    public List<JavaFile> dictGenerator(List<EntityDto> entitys) {
        ArrayList<JavaFile> files = new ArrayList<JavaFile>();
        Map<String, List<EntityDto>> groupDatas = entitys.stream().collect(Collectors.groupingBy(v -> v.getClz().getPackage().getName()));
        for (String entityPackage : groupDatas.keySet()) {
            List<EntityDto> list = groupDatas.get(entityPackage);
            ArrayList<TypeSpec> innerClz = new ArrayList<TypeSpec>();
            for (EntityDto dto : list) {
                ArrayList<FieldSpec> fieldSpecs = new ArrayList<FieldSpec>();
                for (FieldDto field : dto.getFields()) {
                    fieldSpecs.add(FieldSpec.builder(String.class, (String)field.getFieldName(), (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.STATIC, Modifier.PUBLIC}).initializer("$S", new Object[]{field.getFieldName()}).build());
                }
                TypeSpec sub = TypeSpec.classBuilder((String)dto.getType()).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.STATIC, Modifier.PUBLIC}).addFields(fieldSpecs).build();
                innerClz.add(sub);
            }
            TypeSpec constants = TypeSpec.classBuilder((String)"HrConstants").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypes(innerClz).build();
            JavaFile javaFile = JavaFile.builder((String)entityPackage.toString(), (TypeSpec)constants).build();
            files.add(javaFile);
        }
        return files;
    }

    private List<List<Class<? extends Item>>> getPath(List<List<Class<? extends Item>>> total, List<Class<? extends Item>> pathClz, EntityDto entityDto) {
        if (total == null) {
            total = new ArrayList<List<Class<? extends Item>>>();
        }
        if (pathClz == null) {
            Class clz = entityDto.getClz();
            pathClz = Arrays.asList(clz);
        } else {
            total.add(pathClz);
        }
        for (Class fkClz : entityDto.getFkTableClz()) {
            if (!pathClz.contains(fkClz)) {
                ArrayList<Class<? extends Item>> temp = new ArrayList<Class<? extends Item>>();
                temp.addAll(pathClz);
                temp.add(fkClz);
                this.getPath(total, temp, GlobalData.entityDto((Class)fkClz));
                continue;
            }
            total.add(pathClz);
        }
        return total;
    }

    public List<JavaFile> ClzPath(List<EntityDto> entitys) {
        ArrayList<JavaFile> files = new ArrayList<JavaFile>();
        for (EntityDto entityDto : entitys) {
            List<List<Class<? extends Item>>> list = this.getPath(null, null, entityDto);
            ArrayList<FieldSpec> fieldSpecs = new ArrayList<FieldSpec>();
            for (List<Class<? extends Item>> clzss : list) {
                String name = "";
                for (Class<? extends Item> clz : clzss) {
                    name = name + clz.getSimpleName() + "_";
                }
                name = name.substring(0, name.length() - 1);
                Class[] classes = clzss.toArray(new Class[clzss.size()]);
                Object[] bundle = new ClassName[classes.length];
                String str = "";
                for (int i = 0; i < classes.length; ++i) {
                    bundle[i] = ClassName.get((Class)classes[i]);
                    str = str + "$T.class,";
                }
                str = str.substring(0, str.length() - 1);
                fieldSpecs.add(FieldSpec.builder(Class[].class, (String)name, (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.STATIC, Modifier.PUBLIC}).initializer("new Class[]{" + str + "}", bundle).build());
            }
            TypeSpec constants = TypeSpec.classBuilder((String)("V" + entityDto.getClz().getSimpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addFields(fieldSpecs).build();
            JavaFile javaFile = JavaFile.builder((String)(entityDto.getClz().getPackage().getName() + ".V"), (TypeSpec)constants).build();
            files.add(javaFile);
        }
        return files;
    }
}

