/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins.generator;

import cn.wwwlike.vlife.base.Item;
import com.squareup.javapoet.JavaFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GeneratorUtils {
    public boolean compileClzExist1(ClassLoader loader, Class<? extends Item> clz, CLZ_TYPE type) {
        String packageName = clz.getPackage().getName();
        int index = packageName.lastIndexOf("entity");
        String className = null;
        if (type == CLZ_TYPE.API) {
            className = packageName.substring(0, index) + "api." + clz.getSimpleName() + "Api";
        } else if (type == CLZ_TYPE.SERVICE) {
            className = packageName.substring(0, index) + "service." + clz.getSimpleName() + "Service";
        } else if (type == CLZ_TYPE.DAO) {
            className = packageName.substring(0, index) + "dao." + clz.getSimpleName() + "Dao";
        } else if (type == CLZ_TYPE.VITEM) {
            className = packageName.substring(0, index) + "item." + clz.getSimpleName() + "Item";
        }
        if (className != null) {
            try {
                loader.loadClass(className);
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean sourceClzExist(Class itemClz, String basePath, CLZ_TYPE type) {
        String packageName = itemClz.getPackage().getName();
        int index = packageName.lastIndexOf(".");
        String key = type.name().toLowerCase();
        String filePath = basePath + "\\" + (packageName.substring(0, index) + "\\" + key + "\\" + itemClz.getSimpleName() + StringUtils.capitalize((String)key)).replaceAll("\\.", "\\\\");
        return new File(filePath + ".java").exists();
    }

    public void createJavaFile(JavaFile javaFile, String path) throws IOException {
        String targetDirectory = "target/generated-sources/java";
        File dir = new File(targetDirectory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        javaFile.writeTo(dir);
    }

    public void createJavaFiles(String targetDirectory, Boolean cover, List<JavaFile> javaFiles) throws IOException {
        File dir = new File(targetDirectory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (JavaFile javaFile : javaFiles) {
            javaFile.writeTo(dir);
        }
    }

    static enum CLZ_TYPE {
        API,
        DAO,
        SERVICE,
        VITEM,
        DICT;

    }
}

