/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins.generator.api;

import cn.wwwlike.base.model.IModel;
import cn.wwwlike.plugins.generator.api.Method;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.base.VoBean;
import cn.wwwlike.vlife.objship.dto.BeanDto;
import cn.wwwlike.vlife.objship.dto.EntityDto;
import cn.wwwlike.vlife.objship.dto.FieldDto;
import cn.wwwlike.vlife.objship.read.GlobalData;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;

public class ApiMethodCreate {
    public static MethodSpec createMethod(Method methodEnum, Class<? extends Item> itemClz) {
        return ApiMethodCreate.createMethod(methodEnum, itemClz, methodEnum.getParamsType(), methodEnum.getReturnType());
    }

    public static MethodSpec createMethod(Method methodEnum, Class<? extends Item> itemClz, Class in, Class out) {
        String methodName = methodEnum.methodName(itemClz, in);
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        String[] commonts = ApiMethodCreate.methodComment(methodEnum, itemClz, in, out);
        Object dto = null;
        CodeBlock.Builder methodComment = CodeBlock.builder();
        methodComment.addStatement(commonts[0], new Object[0]);
        methodComment.addStatement("@param " + methodEnum.getParamsName() + " " + commonts[1], new Object[0]);
        methodComment.addStatement("@return " + commonts[2], new Object[0]);
        Class[] returnClz = methodEnum.realReturnType(out);
        TypeName returnGenic = null;
        if (returnClz.length == 2) {
            TypeName returnTypeName = TypeName.get((Type)returnClz[1]);
            returnGenic = ParameterizedTypeName.get((ClassName)ClassName.get((Class)returnClz[0]), (TypeName[])new TypeName[]{returnTypeName});
        } else {
            returnGenic = TypeName.get((Type)returnClz[0]);
        }
        ParameterSpec.Builder inSpec = ParameterSpec.builder((Type)methodEnum.realParamsType(in), (String)methodEnum.getParamsName(), (Modifier[])new Modifier[0]);
        if (methodEnum.getParamsAnnotationClz() != null) {
            AnnotationSpec.Builder pathAnnotation = AnnotationSpec.builder((Class)methodEnum.getParamsAnnotationClz());
            inSpec.addAnnotation(pathAnnotation.build());
        }
        methodSpec.addParameter(inSpec.build());
        AnnotationSpec.Builder methodAnnotation = AnnotationSpec.builder((Class)ApiMethodCreate.methodAnnotation(in, methodEnum));
        methodAnnotation.addMember("value", "\"" + methodEnum.getPath(methodName) + "\"", new Object[0]);
        Method.MethodContent mtype = methodEnum.getMethodContent();
        if (Method.MethodContent.save == mtype) {
            methodSpec.addStatement("return service.save(dto)", new Object[0]);
        } else if (mtype == Method.MethodContent.remove) {
            methodSpec.addStatement("return service.remove(id)", new Object[0]);
        } else if (mtype == Method.MethodContent.page && Item.class.isAssignableFrom(out)) {
            methodSpec.addStatement("return service.findPage(" + methodEnum.getParamsName() + ")", new Object[0]);
        } else if (mtype == Method.MethodContent.page && VoBean.class.isAssignableFrom(out)) {
            methodSpec.addStatement("return service.queryPage(" + out.getSimpleName() + ".class," + methodEnum.getParamsName() + ")", new Object[0]);
        } else if (mtype == Method.MethodContent.list && Item.class.isAssignableFrom(out)) {
            methodSpec.addStatement("return service.find(" + methodEnum.getParamsName() + ")", new Object[0]);
        } else if (mtype == Method.MethodContent.list && VoBean.class.isAssignableFrom(out)) {
            methodSpec.addStatement("return service.query(" + out.getSimpleName() + ".class," + methodEnum.getParamsName() + ")", new Object[0]);
        } else if (mtype == Method.MethodContent.one && Item.class.isAssignableFrom(out)) {
            methodSpec.addStatement("List<" + out.getSimpleName() + "> list=service.find(" + methodEnum.getParamsName() + ")", new Object[0]);
            methodSpec.addStatement("return list.get(0)", new Object[0]);
        } else if (mtype == Method.MethodContent.one && VoBean.class.isAssignableFrom(out)) {
            methodSpec.addStatement("List<" + out.getSimpleName() + "> list=service.query(" + out.getSimpleName() + ".class," + methodEnum.getParamsName() + ")", new Object[0]);
            methodSpec.addStatement("return list.get(0)", new Object[0]);
        } else if (mtype == Method.MethodContent.detail && Item.class.isAssignableFrom(out)) {
            methodSpec.addStatement("return service.findOne(" + methodEnum.getParamsName() + ")", new Object[0]);
        } else if (mtype == Method.MethodContent.detail && VoBean.class.isAssignableFrom(out)) {
            methodSpec.addStatement("return service.queryOne(" + out.getSimpleName() + ".class," + methodEnum.getParamsName() + ")", new Object[0]);
        }
        methodSpec.returns(returnGenic).addJavadoc(methodComment.build()).addAnnotation(methodAnnotation.build());
        return methodSpec.build();
    }

    public static String filterKey(String modelName, String itemClzName) {
        String[] ends = new String[]{"vo", "dto", "bean", "pojo", "req", "do", "query", "request", "page", "detail", "details", "string", "list"};
        String name = modelName;
        for (String str : ends) {
            name = StringUtils.replaceIgnoreCase((String)name, (String)str, (String)"");
        }
        name = StringUtils.replaceIgnoreCase((String)name, (String)itemClzName, (String)"");
        return name;
    }

    public static String[] methodComment(Method methodEnum, Class<? extends Item> item, Class param, Class out) {
        EntityDto entityDto = GlobalData.entityDto(item);
        param = param == null ? methodEnum.getParamsType() : param;
        out = out == null ? methodEnum.getReturnType() : out;
        String itemName = entityDto.getTitle();
        String paramName = "";
        String returnName = "";
        BeanDto beanDto = null;
        if (IModel.class.isAssignableFrom(param)) {
            beanDto = GlobalData.get((Class)param);
            paramName = beanDto.getTitle();
        } else {
            String paramProperty = methodEnum.getParamsName();
            Optional<FieldDto> optional = entityDto.getFields().stream().filter(fieldDto -> fieldDto.getFieldName().equalsIgnoreCase(paramProperty)).findFirst();
            if (optional.isPresent()) {
                paramName = optional.get().getTitle();
            }
        }
        if (IModel.class.isAssignableFrom(out)) {
            beanDto = GlobalData.get((Class)out);
            returnName = beanDto.getTitle();
        }
        return methodEnum.getMethodComment(itemName, paramName, returnName);
    }

    private static Class methodAnnotation(Class in, Method methodEnum) {
        return methodEnum.getMethodAnnotationClz();
    }
}

