/*
 * Decompiled with CFR 0.152.
 */
package cn.wwwlike.plugins.generator.api;

import cn.wwwlike.base.model.IdBean;
import cn.wwwlike.plugins.generator.api.ApiMethodCreate;
import cn.wwwlike.plugins.generator.api.Method;
import cn.wwwlike.vlife.base.Item;
import cn.wwwlike.vlife.bean.PageVo;
import cn.wwwlike.vlife.query.CustomQuery;
import cn.wwwlike.vlife.query.req.PageQuery;
import cn.wwwlike.vlife.query.req.VlifeQuery;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public enum MethodTypeEnum implements Method
{
    save("\u4fdd\u5b58", "save", PostMapping.class, IdBean.class, "dto", IdBean.class, RequestBody.class, "NAME_ALL", Method.MethodContent.save),
    commit("\u63d0\u4ea4", "", PostMapping.class, IdBean.class, "dto", IdBean.class, RequestBody.class, "ONLY_KEY", Method.MethodContent.save),
    remove("\u903b\u8f91\u5220\u9664", "remove", DeleteMapping.class, String.class, "id", Long.class, PathVariable.class, "NAME_PREFIX", Method.MethodContent.remove),
    page("\u5206\u9875\u67e5\u8be2", "page", GetMapping.class, PageQuery.class, "req", PageVo.class, null, "NAME_ALL", Method.MethodContent.page),
    list("\u5217\u8868\u67e5\u8be2", "list", GetMapping.class, VlifeQuery.class, "req", List.class, null, "NAME_ALL", Method.MethodContent.list),
    get_one("\u5355\u6761\u67e5\u8be2", "find", GetMapping.class, CustomQuery.class, "bean", IdBean.class, null, "NAME_ALL", Method.MethodContent.one),
    post_one("", "", PostMapping.class, CustomQuery.class, "bean", IdBean.class, RequestBody.class, "ONLY_KEY", Method.MethodContent.one),
    detail("\u660e\u7ec6\u67e5\u8be2", "detail", GetMapping.class, String.class, "id", IdBean.class, PathVariable.class, "NAME_ALL", Method.MethodContent.detail);

    String title;
    String prefix;
    Class methodAnnotationClz;
    Class paramsType;
    String paramsName;
    Class returnType;
    Class paramsAnnotationClz;
    String nameType = "NAME_ALL";
    Method.MethodContent methodContent;

    private MethodTypeEnum(String title, String prefix, Class methodAnnotationClz, Class paramsType, String paramsName, Class returnType, Class paramsAnnotationClz, String nameType, Method.MethodContent methodContent) {
        this.title = title;
        this.prefix = prefix;
        this.methodAnnotationClz = methodAnnotationClz;
        this.paramsType = paramsType;
        this.paramsName = paramsName;
        this.returnType = returnType;
        this.paramsAnnotationClz = paramsAnnotationClz;
        this.nameType = nameType;
        this.methodContent = methodContent;
    }

    @Override
    public Class[] realReturnType(Class out) {
        Class defOut = this.getReturnType();
        if (out == defOut) {
            return (Class[])ArrayUtils.toArray((Object[])new Class[]{out});
        }
        if (out == null) {
            return (Class[])ArrayUtils.toArray((Object[])new Class[]{defOut});
        }
        if (defOut.isInterface() && defOut.isAssignableFrom(out)) {
            return (Class[])ArrayUtils.toArray((Object[])new Class[]{out});
        }
        if (defOut.isInterface() && !defOut.isAssignableFrom(out)) {
            return (Class[])ArrayUtils.toArray((Object[])new Class[]{defOut, out});
        }
        return (Class[])ArrayUtils.toArray((Object[])new Class[]{defOut, out});
    }

    @Override
    public Class realParamsType(Class in) {
        if (in == null) {
            return this.getParamsType();
        }
        return in;
    }

    @Override
    public String getPath(String methodName) {
        String path = "/" + methodName;
        if (this.getNameType().equals("NAME_ALL")) {
            String key = StringUtils.uncapitalize((String)StringUtils.replaceIgnoreCase((String)methodName, (String)this.getPrefix(), (String)""));
            path = "/" + this.getPrefix();
            if (StringUtils.isNotEmpty((CharSequence)key)) {
                path = path + "/" + key;
            }
        }
        if (this.getParamsAnnotationClz() == PathVariable.class) {
            path = path + "/{" + this.getParamsName() + "}";
        }
        return path;
    }

    @Override
    public <T extends Item> String methodName(Class<T> itemClz, Class in) {
        String name = ApiMethodCreate.filterKey(in.getSimpleName(), itemClz.getSimpleName());
        if (this.nameType == "NAME_PREFIX") {
            return this.getPrefix();
        }
        if (this.nameType == "ONLY_KEY") {
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                return StringUtils.uncapitalize((String)name);
            }
            return StringUtils.uncapitalize((String)itemClz.getSimpleName());
        }
        return this.getPrefix() + (name != null ? StringUtils.capitalize((String)name) : "");
    }

    @Override
    public String[] getMethodComment(String itemName, String inName, String returnName) {
        String[] restr = null;
        switch (this.getMethodContent()) {
            case detail: {
                restr = new String[]{this.getTitle() + returnName, inName, returnName};
                break;
            }
            case remove: {
                restr = new String[]{this.getTitle() + returnName, inName, "\u5df2\u5220\u9664\u6570\u91cf"};
                break;
            }
            default: {
                restr = new String[]{this.getTitle() + returnName, inName, returnName};
            }
        }
        return restr;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Class getMethodAnnotationClz() {
        return this.methodAnnotationClz;
    }

    @Override
    public Class getParamsType() {
        return this.paramsType;
    }

    @Override
    public String getParamsName() {
        return this.paramsName;
    }

    @Override
    public Class getReturnType() {
        return this.returnType;
    }

    @Override
    public Class getParamsAnnotationClz() {
        return this.paramsAnnotationClz;
    }

    public String getNameType() {
        return this.nameType;
    }

    @Override
    public Method.MethodContent getMethodContent() {
        return this.methodContent;
    }
}

